#' @title Data for Genotypes by Environment Interaction (GEI)
#' @name   Maiz
#' @docType data
#' @keywords datasets
#' @usage data(Maiz)
#' @description \code{Maiz} is used for performing Genotypes by Environment Interaction (GEI) Analysis.
#' @format A \code{data.frame} 1320 obs. of  6 variables.
#' @details
#'        \itemize{
#'        \item{Gen} Genotype
#'        \item{Institute} Institute
#'        \item{Rep} Replicate
#'        \item{Block} Block
#'        \item{Env} Environment
#'        \item{Yield} Yield Response
#'        }
#'
#' @author
#' \enumerate{
#'     \item Muhammad Yaseen (\email{myaseen208@gmail.com})
#'     \item Jose Crossa (\email{j.crossa@cgiar.org})
#'     \item Sergio Perez-Elizalde (\email{sergiop@colpos.mx})
#'     \item Diego Jarquin (\email{diego.jarquin@gmail.com})
#'     \item Jose Miguel Cotes
#'     \item Kert Viele
#'     \item Genzhou Liu
#'     \item Paul L. Cornelius
#'    }
#'
#' @references
#'  Crossa, J., Perez-Elizalde, S., Jarquin, D., Cotes, J.M., Viele, K., Liu, G., and Cornelius, P.L. (2011)
#'  Bayesian Estimation of the Additive Main Effects and Multiplicative Interaction Model
#'  \emph{Crop Science}, \strong{51}, 1458–1469.
#'  (\href{https://dl.sciencesocieties.org/publications/cs/abstracts/51/4/1458?access=0&view=pdf}{doi: 10.2135/cropsci2010.06.0343})
#'
#' @examples
#' data(Maiz)
#'
NULL
