% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconc.R
\name{reconc_gaussian}
\alias{reconc_gaussian}
\title{Analytical reconciliation of Gaussian base forecasts}
\usage{
reconc_gaussian(S, base_forecasts.mu, base_forecasts.Sigma)
}
\arguments{
\item{S}{summing matrix (n x n_bottom).}

\item{base_forecasts.mu}{a vector containing the means of the base forecasts.}

\item{base_forecasts.Sigma}{a matrix containing the covariance matrix of the base forecasts.}
}
\value{
A list containing the reconciled forecasts. The list has the following named elements:
\itemize{
\item \code{bottom_reconciled_mean}: reconciled mean for the bottom forecasts;
\item \code{bottom_reconciled_covariance}: reconciled covariance for the bottom forecasts;
\item \code{upper_reconciled_mean}: reconciled mean for the upper forecasts;
\item \code{upper_reconciled_covariance}: reconciled covariance for the upper forecasts.
}
}
\description{
Closed form computation of the reconciled forecasts in case of Gaussian base forecasts.
}
\details{
The order of the base forecast means and covariance is given by the order of the time series in the summing matrix.
}
\examples{

library(bayesRecon)

# Create a minimal hierarchy with 2 bottom and 1 upper variable
rec_mat <- get_reconc_matrices(agg_levels=c(1,2), h=2)
S <- rec_mat$S

#Set the parameters of the Gaussian base forecast distributions
mu1 <- 2
mu2 <- 4
muY <- 9
mus <- c(muY,mu1,mu2)

sigma1 <- 2
sigma2 <- 2
sigmaY <- 3
sigmas <- c(sigmaY,sigma1,sigma2)

Sigma <- diag(sigmas^2)  #need to transform into covariance matrix
analytic_rec <- reconc_gaussian(S, base_forecasts.mu = mus,
                               base_forecasts.Sigma = Sigma)

bottom_means <- analytic_rec$bottom_reconciled_mean
upper_means  <- analytic_rec$upper_reconciled_mean
bottom_cov   <- analytic_rec$bottom_reconciled_covariance
upper_cov    <- analytic_rec$upper_reconciled_covariance

}
\references{
Corani, G., Azzimonti, D., Augusto, J.P.S.C., Zaffalon, M. (2021). \emph{Probabilistic Reconciliation of Hierarchical Forecast via Bayes’ Rule}. In: Hutter, F., Kersting, K., Lijffijt, J., Valera, I. (eds) Machine Learning and Knowledge Discovery in Databases. ECML PKDD 2020. Lecture Notes in Computer Science(), vol 12459. Springer, Cham. \doi{10.1007/978-3-030-67664-3_13}.

Zambon, L., Agosto, A., Giudici, P., Corani, G. (2023). \emph{Properties of the reconciled distributions for Gaussian and count forecasts}. \doi{10.48550/arXiv.2303.15135}.
}
\seealso{
\code{\link[=reconc_BUIS]{reconc_BUIS()}}
}
