% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopodShape.R
\name{lopodShape}
\alias{lopodShape}
\title{Crate Shape object for a parameter estimated in a LopodModel}
\usage{
lopodShape(LopodModel, param, extrapolate = T, metric = NULL, quant = 0.5)
}
\arguments{
\item{LopodModel}{A LopodModel object}

\item{param}{Unit-level model parameter to be mapped. Values "psy_Sampled" can be mapped for models without CAR analyses, "psy_i" for LopodModels with CAR analysis and "pp","cellpres_i", "pCorr","sim_y","sim_true_y","sim_false_y" for both.}

\item{extrapolate}{Boolean. If True, parameters are mapped for cells that have not been sampled, this can only be done in LopodModels with CAR analysis. Only plotted for "psy_i", "pp" and, "cellpres_i".}

\item{metric}{"mean" or "sd". Plots the mean or standard deviation of the posterior distribution. If NULL, the value in quant is used.}

\item{quant}{Returns the raster for a given quantile of the Posterior Distribution. Default is 0.5 (the median of the posterior distribution). Not used if metric is other than NULL}
}
\value{
A Raster object.
}
\description{
Crate Shape object for a parameter estimated in a LopodModel
}
\examples{
\dontrun{
data("Andropogon_shape", package = "bayesLopod")
ld_Shape = shapeLopodData(Shapefile = Andropogon_shape, fieldN = "sampEffort",
fieldY = "detections",  Adjacency = TRUE, keepFields = FALSE)
mLopodShape = modelLopod(LopodData = ld_Shape, varP = TRUE, q = NULL,
pmin = 0, CAR = TRUE, nChains = 4,warmup = 500,sampling = 100,nCores =4)
psyShape_95 = lopodShape(mLopodShape, "psy_i", extrapolate = FALSE,  quant = 0.95)
psyShape_05 = lopodShape(mLopodShape, "psy_i", extrapolate = TRUE, quant = 0.05)
 #Visualize results
sp::spplot(psyShape_05, zcol = "psy_i")
sp::spplot(psyShape_95, zcol = "psy_i")
}
}
