% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Job.R
\name{makeJob}
\alias{makeJob}
\alias{Job}
\alias{Experiment}
\title{Jobs and Experiments}
\usage{
makeJob(id, reader = NULL, reg = getDefaultRegistry())
}
\arguments{
\item{id}{[\code{integer(1)} or \code{data.table}]\cr
Single integer to specify the job or a \code{data.table} with column \code{job.id}
and exactly one row.}

\item{reader}{[\code{RDSReader} | \code{NULL}]\cr
Reader object to retrieve files. Used internally to cache reading from the file system.
The default (\code{NULL}) does not make use of caching.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{Job} | \code{Experiment}].
}
\description{
Jobs and Experiments are abstract objects which hold all information necessary to execute a single computational
job for a \code{\link{Registry}} or \code{\link{ExperimentRegistry}}, respectively.

They can be created using the constructor \code{makeJob} which takes a single job id.
Jobs and Experiments are passed to reduce functions like \code{\link{reduceResults}}.
Furthermore, Experiments can be used in the functions of the \code{\link{Problem}} and \code{\link{Algorithm}}.
Jobs and Experiments hold these information:
\describe{
 \item{\code{job.id}}{Job ID as integer.}
 \item{\code{pars}}{
   Job parameters as named list.
   For \code{\link{ExperimentRegistry}}, the parameters are divided into the sublists \dQuote{prob.pars} and \dQuote{algo.pars}.
 }
 \item{\code{seed}}{Seed which is set via \code{\link{doJobCollection}} as scalar integer.}
 \item{\code{resources}}{Computational resources which were set for this job as named list.}
 \item{\code{external.dir}}{
   Path to a directory which is created exclusively for this job. You can store external files here.
   Directory is persistent between multiple restarts of the job and can be cleaned by calling \code{\link{resetJobs}}.
 }
 \item{\code{fun}}{Job only: User function passed to \code{\link{batchMap}}.}
 \item{\code{prob.name}}{Experiments only: Problem id.}
 \item{\code{algo.name}}{Experiments only: Algorithm id.}
 \item{\code{problem}}{Experiments only: \code{\link{Problem}}.}
 \item{\code{instance}}{Experiments only: Problem instance.}
 \item{\code{algorithm}}{Experiments only: \code{\link{Algorithm}}.}
 \item{\code{repl}}{Experiments only: Replication number.}
}

Note that the slots \dQuote{pars}, \dQuote{fun}, \dQuote{algorithm} and \dQuote{problem}
lazy-load required files from the file system and construct the object on the first access.
The realizations are cached for all slots except \dQuote{instance} (which might be stochastic).

Jobs and Experiments can be executed manually with \code{\link{execJob}}.
}
\examples{
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
batchMap(function(x, y) x + y, x = 1:2, more.args = list(y = 99), reg = tmp)
submitJobs(resources = list(foo = "bar"), reg = tmp)
job = makeJob(1, reg = tmp)
print(job)

# Get the parameters:
job$pars

# Get the job resources:
job$resources

# Execute the job locally:
execJob(job)
}
