% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completed.R
\name{batch_completed}
\alias{batch_completed}
\title{Batch Completed?}
\usage{
batch_completed(path, failed = FALSE)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}

\item{failed}{A logical scalar specifying how to treat files
that previously failed to process. If FALSE (the default) failed files
are excluded, if NA they are included and if TRUE they are only included.}
}
\value{
A flag specifying whether batch processing is complete.
}
\description{
Tests if there are any remaining files to process as listed
by \code{\link[=batch_files_remaining]{batch_files_remaining()}}.
}
\details{
By default, files that previously failed to process are excluded.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_completed(path)
batch_run(path, ask = FALSE)
batch_completed(path)
batch_cleanup(path)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_process]{batch_process()}}
}
