% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_jsdglobal}
\alias{setup_jsdglobal}
\title{Setup Global JSD Design Object}
\usage{
setup_jsdglobal(k, p0, shape1 = 1, shape2 = 1)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{shape1}{First common shape parameter of the beta prior.}

\item{shape2}{Second common shape parameter of the beta prior.}
}
\value{
An S3 object of class \code{jsdglobal}
}
\description{
Setup Global JSD Design Object
}
\details{
The class \code{jsdglobal} implements a version of the power prior
design, in which information is shared based on pairwise similarity
and overall heterogeneity between baskets. Both pairwise similarity and
overall heterogeneity are assessed using the Jensen-Shannon divergence.
}
\examples{
design_jsdglobal <- setup_jsdglobal(k = 3, p0 = 0.2)
}
\references{
Baumann, L., Sauer, L., & Kieser, M. (2024). A basket trial
design based on power priors. arXiv:2309.06988.
}
