% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/adjust_lambda.R
\name{adjust_lambda}
\alias{adjust_lambda}
\alias{adjust_lambda,OneStageBasket-method}
\title{Adjust Lambda}
\usage{
adjust_lambda(
  design,
  alpha = 0.025,
  theta1 = NULL,
  n,
  epsilon,
  tau,
  logbase,
  prune,
  prec_digits,
  ...
)

\S4method{adjust_lambda}{OneStageBasket}(
  design,
  alpha = 0.025,
  theta1 = NULL,
  n,
  epsilon,
  tau,
  logbase,
  prune = FALSE,
  prec_digits,
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupBasket}.}

\item{alpha}{The one-sided signifance level.}

\item{theta1}{Probabilities under the alternative hypothesis. If
\code{length(theta1) ==  1}, then this is a common probability for all
baskets. If \code{is.null(theta1)} then the type 1 error rate under the
global null hypothesis is computed.}

\item{n}{The sample size per basket.}

\item{epsilon}{A tuning parameter that determines the amount of borrowing.
See details for more information.}

\item{tau}{A tuning parameter that determines how similar the baskets
have to be that borrowing occurs. See details for more information.}

\item{logbase}{A tuning parameter that determines which logarithm base is
used to compute the Jensen-Shannon divergence. See details for more
information.}

\item{prune}{Whether baskets with a number of responses below the
critical pooled value should be pruned before the final analysis.}

\item{prec_digits}{Number of decimal places that are considered when
adjusting lambda}

\item{...}{Further arguments.}
}
\value{
The greatest value with \code{prec_digits} decimal places for
\code{lambda} which controls the family wise error rate at level
\code{alpha} (one-sided) and the exact family wise error rate for this
value of \code{lambda}.
}
\description{
Finds the value for \code{lambda} such that the family wise error
rate is protected at level \code{alpha}.
}
\details{
\code{adjust_alpha} finds the greatest value with
\code{prec_digits} for \code{lambda} which controls the family wise error
rate at level \code{alpha} (one-sided). A combination of the uniroot
function followed by a grid search is used to finde the correct value
for \code{lambda}.

This method is implemented for the class \code{\link{OneStageBasket}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{OneStageBasket}: Adjust lambda for a single-stage design.
}}

\examples{
design <- setupOneStageBasket(k = 3, shape1 = 1, shape2 = 1, theta0 = 0.2)
adjust_lambda(design = design, alpha = 0.025, n = 15, epsilon = 1, tau = 0,
  logbase = 2, prune = FALSE, prec_digits = 4)
}
