% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_sports.R
\name{mlb_sports}
\alias{mlb_sports}
\title{\strong{MLB Sport IDs}}
\usage{
mlb_sports(sport_id = NULL)
}
\arguments{
\item{sport_id}{The sport_id to return information for.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   sport_id \tab integer \cr
   sport_code \tab character \cr
   sport_link \tab character \cr
   sport_name \tab character \cr
   sport_abbreviation \tab character \cr
   sort_order \tab integer \cr
   active_status \tab logical \cr
}


and the following values:\tabular{rllllrl}{
   sport_id \tab sport_code \tab sport_link \tab sport_name \tab sport_abbreviation \tab sort_order \tab active_status \cr
   1 \tab mlb \tab /api/v1/sports/1 \tab Major League Baseball \tab MLB \tab 11 \tab TRUE \cr
   11 \tab aaa \tab /api/v1/sports/11 \tab Triple-A \tab AAA \tab 101 \tab TRUE \cr
   12 \tab aax \tab /api/v1/sports/12 \tab Double-A \tab AA \tab 201 \tab TRUE \cr
   13 \tab afa \tab /api/v1/sports/13 \tab High-A \tab A+ \tab 301 \tab TRUE \cr
   14 \tab afx \tab /api/v1/sports/14 \tab Low-A \tab A \tab 401 \tab TRUE \cr
   16 \tab rok \tab /api/v1/sports/16 \tab Rookie \tab ROK \tab 701 \tab TRUE \cr
   17 \tab win \tab /api/v1/sports/17 \tab Winter Leagues \tab WIN \tab 1301 \tab TRUE \cr
   8 \tab bbl \tab /api/v1/sports/8 \tab Organized Baseball \tab Pros \tab 1401 \tab TRUE \cr
   21 \tab min \tab /api/v1/sports/21 \tab Minor League Baseball \tab Minors \tab 1402 \tab TRUE \cr
   23 \tab ind \tab /api/v1/sports/23 \tab Independent Leagues \tab IND \tab 2101 \tab TRUE \cr
   51 \tab int \tab /api/v1/sports/51 \tab International Baseball \tab INT \tab 3501 \tab TRUE \cr
   508 \tab nat \tab /api/v1/sports/508 \tab International Baseball (Collegiate) \tab INTC \tab 3502 \tab TRUE \cr
   509 \tab nae \tab /api/v1/sports/509 \tab International Baseball (18 and under) \tab 18U \tab 3503 \tab TRUE \cr
   510 \tab nas \tab /api/v1/sports/510 \tab International Baseball (16 and under) \tab 16U \tab 3505 \tab TRUE \cr
   22 \tab bbc \tab /api/v1/sports/22 \tab College Baseball \tab College \tab 5101 \tab TRUE \cr
   586 \tab hsb \tab /api/v1/sports/586 \tab High School Baseball \tab H.S. \tab 6201 \tab TRUE \cr
}
}
\description{
\strong{MLB Sport IDs}
}
\examples{
\donttest{
  try(mlb_sports())
}
}
