/*
 * Decompiled with CFR 0.152.
 */
package OpenSourceExtensions;

import gnu.trove.TDoubleCollection;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TDoubleHash;
import gnu.trove.impl.hash.THashPrimitiveIterator;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.set.TDoubleSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;

public class TDoubleHashSetAndArray
extends TDoubleHash
implements TDoubleSet,
Externalizable {
    static final long serialVersionUID = 1L;
    private TDoubleArrayList array;

    public TDoubleHashSetAndArray() {
    }

    public TDoubleHashSetAndArray(int n) {
        super(n);
    }

    public TDoubleHashSetAndArray(int n, float f) {
        super(n, f);
    }

    public TDoubleHashSetAndArray(int n, float f, double d) {
        super(n, f, d);
        if (d != 0.0) {
            Arrays.fill(this._set, d);
        }
    }

    public TDoubleHashSetAndArray(Collection<? extends Double> collection) {
        this(Math.max(collection.size(), 10));
        this.addAll(collection);
    }

    public TDoubleHashSetAndArray(TDoubleCollection tDoubleCollection) {
        this(Math.max(tDoubleCollection.size(), 10));
        if (tDoubleCollection instanceof TDoubleHashSetAndArray) {
            TDoubleHashSetAndArray tDoubleHashSetAndArray = (TDoubleHashSetAndArray)tDoubleCollection;
            this._loadFactor = tDoubleHashSetAndArray._loadFactor;
            this.no_entry_value = tDoubleHashSetAndArray.no_entry_value;
            if (this.no_entry_value != 0.0) {
                Arrays.fill(this._set, this.no_entry_value);
            }
            this.setUp((int)Math.ceil(10.0f / this._loadFactor));
        }
        this.addAll(tDoubleCollection);
    }

    public TDoubleHashSetAndArray(double[] dArray) {
        this(Math.max(dArray.length, 10));
        this.array = new TDoubleArrayList(dArray.length);
        this.addAll(dArray);
    }

    public TDoubleIterator iterator() {
        return new TDoubleHashIterator(this);
    }

    public double[] toArray(double[] dArray) {
        double[] dArray2 = this._set;
        byte[] byArray = this._states;
        int n = byArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        if (dArray.length > this._size) {
            dArray[this._size] = this.no_entry_value;
        }
        return dArray;
    }

    public boolean add(double d) {
        int n = this.insertKey(d);
        if (n < 0) {
            return false;
        }
        this.array.add(d);
        this.postInsertHook(this.consumeFreeSlot);
        return true;
    }

    public double[] toArray() {
        return this.array.toArray();
    }

    public double getAtIndex(int n) {
        return this.array.get(n);
    }

    public int size() {
        return this.array.size();
    }

    public boolean remove(double d) {
        this.array.remove(d);
        return true;
    }

    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (obj instanceof Double) {
                double d = (Double)obj;
                if (this.contains(d)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean containsAll(TDoubleCollection tDoubleCollection) {
        for (double d : tDoubleCollection) {
            if (this.contains(d)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(double[] dArray) {
        int n = dArray.length;
        while (n-- > 0) {
            if (this.contains(dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection<? extends Double> collection) {
        boolean bl = false;
        for (Double d : collection) {
            double d2 = d;
            if (!this.add(d2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean addAll(TDoubleCollection tDoubleCollection) {
        boolean bl = false;
        for (double d : tDoubleCollection) {
            if (!this.add(d)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean addAll(double[] dArray) {
        boolean bl = false;
        int n = dArray.length;
        while (n-- > 0) {
            if (!this.add(dArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        TDoubleIterator tDoubleIterator = this.iterator();
        while (tDoubleIterator.hasNext()) {
            if (collection.contains(tDoubleIterator.next())) continue;
            tDoubleIterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(TDoubleCollection tDoubleCollection) {
        if (this == tDoubleCollection) {
            return false;
        }
        boolean bl = false;
        TDoubleIterator tDoubleIterator = this.iterator();
        while (tDoubleIterator.hasNext()) {
            if (tDoubleCollection.contains(tDoubleIterator.next())) continue;
            tDoubleIterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(double[] dArray) {
        boolean bl = false;
        Arrays.sort(dArray);
        double[] dArray2 = this._set;
        byte[] byArray = this._states;
        this._autoCompactTemporaryDisable = true;
        int n = dArray2.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || Arrays.binarySearch(dArray, dArray2[n]) >= 0) continue;
            this.removeAt(n);
            bl = true;
        }
        this._autoCompactTemporaryDisable = false;
        return bl;
    }

    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            double d;
            if (!(obj instanceof Double) || !this.remove(d = ((Double)obj).doubleValue())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(TDoubleCollection tDoubleCollection) {
        boolean bl = false;
        for (double d : tDoubleCollection) {
            if (!this.remove(d)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(double[] dArray) {
        boolean bl = false;
        int n = dArray.length;
        while (n-- > 0) {
            if (!this.remove(dArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public void clear() {
        super.clear();
        double[] dArray = this._set;
        byte[] byArray = this._states;
        int n = dArray.length;
        while (n-- > 0) {
            dArray[n] = this.no_entry_value;
            byArray[n] = 0;
        }
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        double[] dArray = this._set;
        byte[] byArray = this._states;
        this._set = new double[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            double d = dArray[n3];
            this.insertKey(d);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TDoubleSet)) {
            return false;
        }
        TDoubleSet tDoubleSet = (TDoubleSet)object;
        if (tDoubleSet.size() != this.size()) {
            return false;
        }
        int n = this._states.length;
        while (n-- > 0) {
            if (this._states[n] != 1 || tDoubleSet.contains(this._set[n])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this._states.length;
        while (n2-- > 0) {
            if (this._states[n2] != 1) continue;
            n += HashFunctions.hash((double)this._set[n2]);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this._size * 2 + 2);
        stringBuilder.append("{");
        int n = this._states.length;
        int n2 = 1;
        while (n-- > 0) {
            if (this._states[n] != 1) continue;
            stringBuilder.append(this._set[n]);
            if (n2++ >= this._size) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this._size);
        objectOutput.writeFloat(this._loadFactor);
        objectOutput.writeDouble(this.no_entry_value);
        int n = this._states.length;
        while (n-- > 0) {
            if (this._states[n] != 1) continue;
            objectOutput.writeDouble(this._set[n]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        if (by >= 1) {
            this._loadFactor = objectInput.readFloat();
            this.no_entry_value = objectInput.readDouble();
            if (this.no_entry_value != 0.0) {
                Arrays.fill(this._set, this.no_entry_value);
            }
        }
        this.setUp(n);
        while (n-- > 0) {
            double d = objectInput.readDouble();
            this.add(d);
        }
    }

    class TDoubleHashIterator
    extends THashPrimitiveIterator
    implements TDoubleIterator {
        private final TDoubleHash _hash;

        public TDoubleHashIterator(TDoubleHash tDoubleHash) {
            super((TPrimitiveHash)tDoubleHash);
            this._hash = tDoubleHash;
        }

        public double next() {
            this.moveToNextIndex();
            return this._hash._set[this._index];
        }
    }
}

