% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-etiology-regression.R
\name{plot_etiology_strat}
\alias{plot_etiology_strat}
\title{visualize the etiology estimates for each discrete levels}
\usage{
plot_etiology_strat(
  DIR_NPLCM,
  strata_weights = "empirical",
  truth = NULL,
  RES_NPLCM = NULL,
  show_levels = 0,
  is_plot = TRUE
)
}
\arguments{
\item{DIR_NPLCM}{File path to the folder containing posterior samples}

\item{strata_weights}{a vector of weights that sum to one; for each pathogen
the weights specify how the j-th etiology fraction should be combined across all
levels of the discrete predictors in the data; default is \code{"empirical"}
to use empirical weights (observed fractions of subjects across strata).}

\item{truth}{a list of true values, e.g.,
\verb{truth=list(allEti = <a list of etiology fractions, each of identical length - the # of strata; >)};
if available, will be shown in thicker red solid vertical lines.}

\item{RES_NPLCM}{pre-read \code{res_nplcm}; default to \code{NULL}.}

\item{show_levels}{a vector of integers less than or equal to the total number of
levels of strata; default to \code{0} for overall.}

\item{is_plot}{default to TRUE, plotting the figures; if \code{FALSE} only returning summaries}
}
\value{
plotting function
}
\description{
This function visualizes the etiology estimates against one discrete covariate, e.g.,
age groups.
}
\seealso{
Other visualization functions: 
\code{\link{plot.nplcm}()},
\code{\link{plot_BrS_panel}()},
\code{\link{plot_SS_panel}()},
\code{\link{plot_check_common_pattern}()},
\code{\link{plot_check_pairwise_SLORD}()},
\code{\link{plot_etiology_regression}()},
\code{\link{plot_panels}()},
\code{\link{plot_pie_panel}()},
\code{\link{plot_subwt_regression}()}
}
\concept{visualization functions}
