% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_discrete}
\alias{is_discrete}
\title{Check if covariates are discrete}
\usage{
is_discrete(X, X_reg)
}
\arguments{
\item{X}{A data frame of covariates}

\item{X_reg}{The vector of covariates that will stratify the analyses. These
variables have to be categorical. Or a formula (can be tested by \code{plyr::is.formula}),
e.g., \code{~as.factor(SITE8) + as.factor(AGECAT > 1)}.}
}
\value{
\code{TRUE} for all being discrete; \code{FALSE} otherwise.
}
\description{
\code{is_discrete} checks if the specified covariates could be regarded as discrete
variables.
}
\details{
Note that this function should be used with caution. It used
\deqn{nrow(X)/nrow(unique(X[,X_reg,drop=FALSE]))>10} as an \emph{ad hoc} criterion.
It is not the same as \code{\link[plyr:is.discrete]{plyr::is.discrete()}}
}
