% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.plot.R
\name{check.plot.mcmc.2pnob}
\alias{check.plot.mcmc.2pnob}
\title{Plot of the discrimination marginal posterior means against
difficulty marginal posterior means}
\usage{
\method{check.plot}{mcmc.2pnob}(mcmclist, converg.test = TRUE, ...)
}
\arguments{
\item{mcmclist}{A \emph{mcmc.2pnob} or \emph{mcmc.3pnob} class object.}

\item{converg.test}{Checking if Rhat is major that 1.1.}

\item{...}{Further arguments.}
}
\value{
A plot of the discrimination marginal posterior means against
difficulty marginal posterior means. For the Three-parameter model
the guessing marginal posterior means are represented by the
number size of the item.
}
\description{
Marginal Posterior means of \eqn{b_j} plotted against the
marginal posterior means of \eqn{a_j}. Each point is labeled with
the number of the corresponding Item.

For the Three-Parameter Normal Ogive Item Response Model \emph{(3pno)},
the size of the numbers refers to the marginal posterior means of
\eqn{c_j}.

The Potential Scale Reduction Factor (\emph{Rhat}) is calculated
for each chain, \emph{bairt} generates a single MCMC and evaluates
convergence by breaking the chain in three sub chains and comparing the
between- and within-subchain variance.

The \emph{black color suggests convergence} and
\emph{red items indicate convergence problems} (\emph{Rhat greater than 1.1}).
}
\details{
If \emph{converg.test = TRUE} the items with Rhat menor that 1.1 are print
in red color. It is useful for quick check of the convergence.
}
\examples{
# data for model
data("MathTest")

# Only for the first 500 examinees of the data MathTest
# Two-Parameter Normal Ogive Model
model2 <- mcmc.2pnob(MathTest[1:500,], iter = 400, burning = 100)
check.plot(model2)
chain.study(model2, parameter = "b", chain = 12)
chain.study(model2, parameter = "theta", chain = 10)

\donttest{
# For all examinees of the data MathTest
# Two-Parameter Normal Ogive Model
modelAll2 <- mcmc.2pnob(MathTest, iter = 3500, burning = 500, thin = 10)
check.plot(modelAll2)
chain.study(modelAll2, parameter = "b", chain = 14)
chain.study(modelAll2, parameter = "theta", chain = 10)

# Three-Parameter Normal Ogive Model
modelAll3 <- mcmc.3pnob(MathTest, iter = 3500, burning = 500, thin = 10)
check.plot(modelAll3)
chain.study(modelAll3, parameter = "b", chain = 12)
chain.study(modelAll3, parameter = "c", chain = 10)
}

## End(Not run)

}
\references{
Johnson, V. E. & Albert, J. H. (1999). Ordinal Data Modeling.
New York: Springer.

Gelman, A., Carlin, J. B., Stern, H. S. & Rubin, B. (2004).
Bayesian Data Analysis.New York: Chapman & Hall/CRC.
}
\seealso{
\code{\link{mcmc.2pnob}}, \code{\link{mcmc.3pnob}} and
\code{\link{continue.mcmc.bairt}}.
}
\author{
Javier Martínez
}
