% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loocv.R
\name{loocv}
\alias{loocv}
\title{Leave one out cross-validation for \code{baggr} models}
\usage{
loocv(data, return_models = FALSE, ...)
}
\arguments{
\item{data}{Input data frame - same as for \link{baggr} function.}

\item{return_models}{logical; if FALSE, summary statistics will be returned and the
models discarded;
if TRUE, a list of models will be returned alongside summaries}

\item{...}{Additional arguments passed to \link{baggr}.}
}
\value{
log predictive density value, an object of class \code{baggr_cv};
full model, prior values and \emph{lpd} of each model are also returned
these can be examined by using \code{attributes()} function
}
\description{
Creates $k$ \code{baggr} models by leaving out one group at the time
and calculating log predictive density \eqn{lpd_{k}}
for that group (see Gelman \emph{et al}). Returned value is a \eqn{-2\sum lpd_{k}}.
Inputs to this function are same as to \link{baggr}, with additional
option to return individual models.
}
\details{
For running more computation-intensive models, consider setting the \code{mc.cores}
option before running \code{loocv}, e.g. \code{options(mc.cores = 4)} (by default \code{baggr} runs
4 MCMC chains in parallel).
As a default, rstan runs "silently" (\code{refresh=0}). To see sampling progress, please
set e.g. \code{loocv(data, refresh = 500)}.

For more information on cross-validation see
\href{http://www.stat.columbia.edu/~gelman/research/published/waic_understand3.pdf}{this overview article}
}
\examples{
\donttest{
# even simple examples may take a while
cv <- loocv(schools, pooling = "partial")
print(cv)      # returns the lpd value
attributes(cv) # more information is included in the object
}

}
\author{
Witold Wiecek
}
