% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_search_transit_gateway_routes}
\alias{ec2_search_transit_gateway_routes}
\title{Search Transit Gateway Routes}
\usage{
ec2_search_transit_gateway_routes(
  TransitGatewayRouteTableId,
  Filter,
  MaxResults = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayRouteTableId}{String. The ID of the transit gateway route table.}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of routes to return.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Searches for routes in the specified
transit gateway route table.
}
\section{TransitGatewayRouteTableId}{

The ID of the transit
gateway route table.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{attachment.transit-gateway-attachment-id}- The id of the transit
gateway attachment.
\item \code{attachment.resource-id} - The resource id of the transit gateway
attachment.
\item \code{attachment.resource-type} - The attachment resource type. Valid
values are \code{vpc} \| \code{vpn} \| \code{direct-connect-gateway} \| \code{peering}
\| \code{connect}.
\item \code{prefix-list-id} - The ID of the prefix list.
\item \code{route-search.exact-match} - The exact match of the specified
filter.
\item \code{route-search.longest-prefix-match} - The longest prefix that
matches the route.
\item \code{route-search.subnet-of-match} - The routes with a subnet that match
the specified CIDR filter.
\item \code{route-search.supernet-of-match} - The routes with a CIDR that
encompass the CIDR filter. For example, if you have 10.0.1.0/29 and
10.0.1.0/31 routes in your route table and you specify
supernet-of-match as 10.0.1.0/30, then the result returns
10.0.1.0/29.
\item \code{state} - The state of the route (\code{active} \| \code{blackhole}).
\item \code{type} - The type of route (\code{propagated} \| \code{static}).
}
}

\section{MaxResults}{

The maximum number of routes to
return.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

