% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_traffic_mirror_filter_network_services}
\alias{ec2_modify_traffic_mirror_filter_network_services}
\title{Modify Traffic Mirror Filter Network Services}
\usage{
ec2_modify_traffic_mirror_filter_network_services(
  TrafficMirrorFilterId,
  AddNetworkService = NULL,
  RemoveNetworkService = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TrafficMirrorFilterId}{String. The ID of the Traffic Mirror filter.}

\item{AddNetworkService}{List. The network service, for example Amazon DNS, that you want to mirror.[optional]}

\item{RemoveNetworkService}{List. The network service, for example Amazon DNS, that you no longer want to mirror.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Traffic Mirror Filter Network Services
}
\section{TrafficMirrorFilterId}{

The ID of the Traffic Mirror
filter.
}

\section{AddNetworkService}{

The network service, for example Amazon DNS,
that you want to mirror.
}

\section{RemoveNetworkService}{

The network service, for
example Amazon DNS, that you no longer want to
mirror.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

