% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_import_instance}
\alias{ec2_import_instance}
\title{Import Instance}
\usage{
ec2_import_instance(
  Platform,
  Description = NULL,
  DiskImage = NULL,
  DryRun = NULL,
  LaunchSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Platform}{String. The instance operating system.}

\item{Description}{String. A description for the instance being imported.[optional]}

\item{DiskImage}{List. The disk image.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{LaunchSpecification}{Object. The launch specification.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Import Instance
}
\section{Platform}{

The instance operating
system.
}

\section{Description}{

A description for the instance being
imported.
}

\section{DiskImage}{

The disk image.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{LaunchSpecification}{

The launch
specification.
}

