% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_vpcs}
\alias{ec2_describe_vpcs}
\title{Describe Vpcs}
\usage{
ec2_describe_vpcs(
  Filter = NULL,
  VpcId = NULL,
  DryRun = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{VpcId}{List.   One or more VPC IDs.  Default: Describes all your VPCs.  [optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more of your
VPCs.
}
\section{Filter}{


One or more filters.
\itemize{
\item \code{cidr} - The primary IPv4 CIDR block of the VPC. The CIDR block you
specify must exactly match the VPC\'s CIDR block for information to
be returned for the VPC. Must contain the slash followed by one or
two digits (for example, \verb{/28}).
\item \code{cidr-block-association.cidr-block} - An IPv4 CIDR block associated
with the VPC.
\item \code{cidr-block-association.association-id} - The association ID for an
IPv4 CIDR block associated with the VPC.
\item \code{cidr-block-association.state} - The state of an IPv4 CIDR block
associated with the VPC.
\item \code{dhcp-options-id} - The ID of a set of DHCP options.
\item \code{ipv6-cidr-block-association.ipv6-cidr-block} - An IPv6 CIDR block
associated with the VPC.
\item \code{ipv6-cidr-block-association.ipv6-pool} - The ID of the IPv6 address
pool from which the IPv6 CIDR block is allocated.
\item \code{ipv6-cidr-block-association.association-id} - The association ID
for an IPv6 CIDR block associated with the VPC.
\item \code{ipv6-cidr-block-association.state} - The state of an IPv6 CIDR
block associated with the VPC.
\item \code{isDefault} - Indicates whether the VPC is the default VPC.
\item \code{owner-id} - The ID of the AWS account that owns the VPC.
\item \code{state} - The state of the VPC (\code{pending} \| \code{available}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC.
}
}

\section{VpcId}{


One or more VPC IDs.

Default: Describes all your VPCs.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{MaxResults}{

The maximum number of results to return
with a single call. To retrieve the remaining results, make another call
with the returned \code{nextToken} value.
}

