% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_transit_gateways}
\alias{ec2_describe_transit_gateways}
\title{Describe Transit Gateways}
\usage{
ec2_describe_transit_gateways(
  TransitGatewayIds = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayIds}{List. The IDs of the transit gateways.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more transit
gateways. By default, all transit gateways are described. Alternatively,
you can filter the results.
}
\section{TransitGatewayIds}{

The IDs of the transit
gateways.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{options.propagation-default-route-table-id} - The ID of the default
propagation route table.
\item \code{options.amazon-side-asn} - The private ASN for the Amazon side of a
BGP session.
\item \code{options.association-default-route-table-id} - The ID of the default
association route table.
\item \code{options.auto-accept-shared-attachments} - Indicates whether there
is automatic acceptance of attachment requests (\code{enable} \|
\code{disable}).
\item \code{options.default-route-table-association} - Indicates whether
resource attachments are automatically associated with the default
association route table (\code{enable} \| \code{disable}).
\item \code{options.default-route-table-propagation} - Indicates whether
resource attachments automatically propagate routes to the default
propagation route table (\code{enable} \| \code{disable}).
\item \code{options.dns-support} - Indicates whether DNS support is enabled
(\code{enable} \| \code{disable}).
\item \code{options.vpn-ecmp-support} - Indicates whether Equal Cost Multipath
Protocol support is enabled (\code{enable} \| \code{disable}).
\item \code{owner-id} - The ID of the AWS account that owns the transit
gateway.
\item \code{state} - The state of the transit gateway (\code{available} \| \code{deleted}
\| \code{deleting} \| \code{modifying} \| \code{pending}).
\item \code{transit-gateway-id} - The ID of the transit gateway.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

