% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_spot_fleet_instances}
\alias{ec2_describe_spot_fleet_instances}
\title{Describe Spot Fleet Instances}
\usage{
ec2_describe_spot_fleet_instances(
  SpotFleetRequestId,
  DryRun = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{SpotFleetRequestId}{String. The ID of the Spot Fleet request.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the running instances for the
specified Spot Fleet.
}
\section{SpotFleetRequestId}{

The ID of the Spot Fleet
request.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{MaxResults}{

The maximum number of
results to return in a single call. Specify a value between 1 and 1000.
The default value is 1000. To retrieve the remaining results, make
another call with the returned \code{NextToken}
value.
}

