% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_instance_attribute}
\alias{ec2_describe_instance_attribute}
\title{Describe Instance Attribute}
\usage{
ec2_describe_instance_attribute(
  Attribute,
  InstanceId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Attribute}{String.   The instance attribute.  Note: The \code{enaSupport} attribute is not supported at this time.}

\item{InstanceId}{String. The ID of the instance.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the specified attribute of the
specified instance. You can specify only one attribute at a time. Valid
attribute values are: \code{instanceType} \| \code{kernel} \| \code{ramdisk} \|
\code{userData} \| \code{disableApiTermination} \|
\code{instanceInitiatedShutdownBehavior} \| \code{rootDeviceName} \|
\code{blockDeviceMapping} \| \code{productCodes} \| \code{sourceDestCheck} \|
\code{groupSet} \| \code{ebsOptimized} \| \code{sriovNetSupport}
}
\section{Attribute}{


The instance attribute.

Note: The \code{enaSupport} attribute is not supported at this time.
}

\section{InstanceId}{

The ID of the instance.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

