% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_fleet_history}
\alias{ec2_describe_fleet_history}
\title{Describe Fleet History}
\usage{
ec2_describe_fleet_history(
  FleetId,
  StartTime,
  DryRun = NULL,
  EventType = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{FleetId}{String. The ID of the EC2 Fleet.}

\item{StartTime}{String. The start date and time for the events, in UTC format (for example, \emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z)....}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{EventType}{String. The type of events to describe. By default, all events are described.[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Fleet History
}
\section{FleetId}{

The ID of the EC2
Fleet.
}

\section{StartTime}{

The start date and time for the events, in
UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{EventType}{

The type
of events to describe. By default, all events are
described.
}

\section{MaxResults}{

The maximum number of results to return
in a single call. Specify a value between 1 and 1000. The default value
is 1000. To retrieve the remaining results, make another call with the
returned \code{NextToken} value.
}

