% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_export_image_tasks}
\alias{ec2_describe_export_image_tasks}
\title{Describe Export Image Tasks}
\usage{
ec2_describe_export_image_tasks(
  DryRun = NULL,
  Filter = NULL,
  ExportImageTaskId = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{ExportImageTaskId}{List. The IDs of the export image tasks.[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes
the specified export image tasks or all of your export image
tasks.
}
\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Filter}{

Filter tasks using the
\code{task-state} filter and one of the following values: \code{active},
\code{completed}, \code{deleting}, or \code{deleted}.
}

\section{ExportImageTaskId}{

The IDs of
the export image tasks.
}

\section{MaxResults}{

The maximum number of
results to return in a single call.
}

