% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_client_vpn_routes}
\alias{ec2_describe_client_vpn_routes}
\title{Describe Client Vpn Routes}
\usage{
ec2_describe_client_vpn_routes(
  ClientVpnEndpointId,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ClientVpnEndpointId}{String. The ID of the Client VPN endpoint.}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return for the request in a single page.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the routes for the
specified Client VPN endpoint.
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN
endpoint.
}

\section{Filter}{


One or more filters. Filter names and values are case-sensitive.
\itemize{
\item \code{destination-cidr} - The CIDR of the route destination.
\item \code{origin} - How the route was associated with the Client VPN endpoint
(\code{associate} \| \code{add-route}).
\item \code{target-subnet} - The ID of the subnet through which traffic is
routed.
}
}

\section{MaxResults}{

The maximum number of results to return for the
request in a single page. The remaining results can be seen by sending
another request with the nextToken value.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

