% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_vpn_gateway}
\alias{ec2_delete_vpn_gateway}
\title{Delete Vpn Gateway}
\usage{
ec2_delete_vpn_gateway(
  VpnGatewayId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpnGatewayId}{String. The ID of the virtual private gateway.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified virtual private
gateway. You must first detach the virtual private gateway from the VPC.
Note that you don\'t need to delete the virtual private gateway if you
plan to delete and recreate the VPN connection between your VPC and your
network.
}
\section{VpnGatewayId}{

The ID of the virtual
private gateway.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

