% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_transit_gateway_peering_attachment}
\alias{ec2_create_transit_gateway_peering_attachment}
\title{Create Transit Gateway Peering Attachment}
\usage{
ec2_create_transit_gateway_peering_attachment(
  TransitGatewayId,
  PeerTransitGatewayId,
  PeerAccountId,
  PeerRegion,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayId}{String. The ID of the transit gateway.}

\item{PeerTransitGatewayId}{String. The ID of the peer transit gateway with which to create the peering attachment.}

\item{PeerAccountId}{String. The AWS account ID of the owner of the peer transit gateway.}

\item{PeerRegion}{String. The Region where the peer transit gateway is located.}

\item{TagSpecification}{List. The tags to apply to the transit gateway peering attachment.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Transit Gateway Peering Attachment
}
\section{TransitGatewayId}{

The ID of the transit
gateway.
}

\section{PeerTransitGatewayId}{

The ID of the peer transit gateway with
which to create the peering attachment.
}

\section{PeerAccountId}{

The AWS
account ID of the owner of the peer transit
gateway.
}

\section{PeerRegion}{

The Region where the peer transit gateway
is located.
}

\section{TagSpecification}{

The tags to apply to the transit gateway
peering attachment.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

