% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_associate_enclave_certificate_iam_role}
\alias{ec2_associate_enclave_certificate_iam_role}
\title{Associate Enclave Certificate Iam Role}
\usage{
ec2_associate_enclave_certificate_iam_role(
  CertificateArn = NULL,
  RoleArn = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{CertificateArn}{String. The ARN of the ACM certificate with which to associate the IAM role.[optional]}

\item{RoleArn}{String. The ARN of the IAM role to associate with the ACM certificate.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Associate Enclave Certificate Iam Role
}
\section{CertificateArn}{

The ARN of
the ACM certificate with which to associate the IAM
role.
}

\section{RoleArn}{

The ARN of the IAM role to associate with the
ACM certificate. You can associate up to 16 IAM roles with an ACM
certificate.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

