% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{File}
\alias{File}
\title{An obligatory wrapper for file names (paths)}
\usage{
File(x)
}
\arguments{
\item{x}{A string, i.e. character vector of length 1, indicating a file path to
an existing file.}
}
\value{
\code{x} with an S3 class attribute "\code{file}".
}
\description{
This function \strong{must} be used
\itemize{
\item in the \strong{arguments} of function \code{fun}
(passed to \code{\link{makeApp}} or \code{\link{makeFiles}}) and/or
\item in the \strong{value returned } by \code{fun}
}
to wrap the character string
indicating a path respectively
\itemize{
\item to an input file ("consumed" by \code{fun} or
\item to an output file ("produced" by \code{fun} as a
\href{https://en.wikipedia.org/wiki/Side_effect_(computer_science)}{side effect}).
}
Otherwise \pkg{autoshiny} cannot distinguish file paths from character strings.
}
