% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-bcr.r
\name{auk_bcr}
\alias{auk_bcr}
\title{Filter the eBird data by Bird Conservation Region}
\usage{
auk_bcr(x, bcr, replace = FALSE)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{bcr}{integer; BCRs to filter by. BCRs are identified by an integer,
from 1 to 66, that can be looked up in the \link{bcr_codes} table.}

\item{replace}{logical; multiple calls to \code{auk_state()} are additive,
unless \code{replace = FALSE}, in which case the previous list of states to
filter by will be removed and replaced by that in the current call.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) to extract data for a set
of \href{http://nabci-us.org/resources/bird-conservation-regions/}{Bird Conservation Regions} (BCRs).
BCRs are ecologically distinct regions in North America with similar bird
communities, habitats, and resource management issues. This function only
defines the filter and, once all filters have been defined, \code{\link[=auk_filter]{auk_filter()}}
should be used to call AWK and perform the filtering.
}
\details{
This function can also work with on an \code{auk_sampling} object if the
user only wishes to filter the sampling event data.
}
\examples{
# bcr codes can be looked up in bcr_codes
dplyr::filter(bcr_codes, bcr_name == "Central Hardwoods")
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_bcr(bcr = 24)
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_bcr(ebd, bcr = 24)
}
\seealso{
Other filter: \code{\link{auk_bbox}},
  \code{\link{auk_breeding}}, \code{\link{auk_complete}},
  \code{\link{auk_country}}, \code{\link{auk_date}},
  \code{\link{auk_distance}}, \code{\link{auk_duration}},
  \code{\link{auk_extent}}, \code{\link{auk_filter}},
  \code{\link{auk_last_edited}},
  \code{\link{auk_observer}}, \code{\link{auk_project}},
  \code{\link{auk_protocol}}, \code{\link{auk_species}},
  \code{\link{auk_state}}, \code{\link{auk_time}}
}
\concept{filter}
