% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-distance.r
\name{auk_distance}
\alias{auk_distance}
\title{Filter eBird data by distance travelled}
\usage{
auk_distance(x, distance, distance_units)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{distance}{integer; 2 element vector specifying the range of distances
to filter by. The default is to accept distances in kilometers, use
\code{distance_units = "miles"} for miles.}

\item{distance_units}{character; whether distances are provided in kilometers
(the default) or miles.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on the distance
travelled on the checklist. This function only defines the filter and, once
all filters have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and
perform the filtering. Note that stationary checklists (i.e. point counts)
have no distance associated with them, however, since these checklists can
be assumed to have 0 distance they will be kept if 0 is in the range defined
by \code{distance}.
}
\details{
This function can also work with on an \code{auk_sampling} object if the
user only wishes to filter the sampling event data.
}
\examples{
# only keep checklists that are less than 10 km long
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_distance(distance = c(0, 10))
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_distance(ebd, distance = c(0, 10))
}
\seealso{
Other filter: \code{\link{auk_bbox}},
  \code{\link{auk_bcr}}, \code{\link{auk_breeding}},
  \code{\link{auk_complete}}, \code{\link{auk_country}},
  \code{\link{auk_date}}, \code{\link{auk_duration}},
  \code{\link{auk_extent}}, \code{\link{auk_filter}},
  \code{\link{auk_last_edited}}, \code{\link{auk_project}},
  \code{\link{auk_protocol}}, \code{\link{auk_species}},
  \code{\link{auk_state}}, \code{\link{auk_time}}
}
\concept{filter}
