% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-ebd.r
\name{auk_ebd}
\alias{auk_ebd}
\title{Reference to eBird data file}
\usage{
auk_ebd(file, file_sampling, sep = "\\t")
}
\arguments{
\item{file}{character; input file.}

\item{file_sampling}{character; optional input sampling event data (i.e.
checklists) file, required if you intend to zero-fill the data to produce a
presence-absence data set. This file consists of just effort information
for every eBird checklist. Any species not appearing in the EBD for a given
checklist is implicitly considered to have a count of 0. This file should
be downloaded at the same time as the basic dataset to ensure they are in
sync.}

\item{sep}{character; the input field separator, the eBird data are tab
separated so this should generally not be modified. Must only be a single
character and space delimited is not allowed since spaces appear in many of
the fields.}
}
\value{
An \code{auk_ebd} object storing the file reference and the desired
filters once created with other package functions.
}
\description{
Create a reference to an eBird Basic Dataset (EBD) file in preparation for
filtering using AWK.
}
\details{
eBird data can be downloaded as a tab-separated text file from the
\href{http://ebird.org/ebird/data/download}{eBird website} after submitting a
request for access. As of February 2017, this file is nearly 150 GB making it
challenging to work with. If you're only interested in a single species or a
small region it is possible to submit a custom download request. This
approach is suggested to speed up processing time.

There are two potential pathways for preparing eBird data. Users wishing to
produce presence only data, should download the
\href{http://ebird.org/ebird/data/download/}{eBird Basic Dataset} and reference
this file when calling \code{auk_ebd()}. Users wishing to produce zero-filled,
presence absence data should additionally download the sampling event data
file associated with the basic dataset This file contains only checklist
information and can be used to infer absences. The sampling event data file
should be provided to \code{auk_ebd()} via the \code{file_sampling} argument. For
further details consult the vignettes.
}
\examples{
# get the path to the example data included in the package
# in practice, provide path to ebd, e.g. f <- "data/ebd_relFeb-2018.txt
f <- system.file("extdata/ebd-sample.txt", package = "auk")
auk_ebd(f)
# to produce zero-filled data, provide a checklist file
f_ebd <- system.file("extdata/zerofill-ex_ebd.txt", package = "auk")
f_cl <- system.file("extdata/zerofill-ex_sampling.txt", package = "auk")
auk_ebd(f_ebd, file_sampling = f_cl)
}
