% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_peak.R
\name{score_peak}
\alias{score_peak}
\alias{scorePeak}
\title{Peak Score}
\usage{
score_peak(object, variable = NULL)

scorePeak(object)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{variable}{Name of model variable to order residuals.}
}
\value{
an object of class 'auditor_score'
}
\description{
This score is calculated on the basis of Peak test, which is used for checking for homoscedasticity of residuals in regression analyses.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# create an explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# calculate score
score_peak(exp_lm)

}
