% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreDW.R
\name{scoreDW}
\alias{scoreDW}
\title{Durbin-Watson Score}
\usage{
scoreDW(object, variable = NULL)
}
\arguments{
\item{object}{An object of class modelAudit or modelResiduals.}

\item{variable}{Name of model variable to order residuals. If value is NULL data order is taken. If value is "Predicted response" or "Fitted values" then data is ordered by fitted values. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}
}
\value{
an object of class scoreAudit
}
\description{
Score based on Durbin-Watson test statistic.
The score value is helpful in comparing models. It is worth pointing out that results of tests like p-value makes sense only
when the test assumptions are satisfied. Otherwise test statistic may be considered as a score.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
scoreDW(lm_au)


}
