% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotModelRanking.R
\name{plotModelRanking}
\alias{plotModelRanking}
\title{Model Ranking Plot}
\usage{
plotModelRanking(object, ..., scores = c("MAE", "MSE", "REC", "RROC"),
  new.score = NULL, table = TRUE)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{scores}{Vector of score names to be plotted.}

\item{new.score}{A named list of functions that take one argument: object of class ModelAudit and return a numeric value. The measure calculated by the function should have the property that lower score value indicates better model.}

\item{table}{Logical. Specifies if rable with score values should be plotted}
}
\value{
ggplot object
}
\description{
Radar plot with model scores. Scores are scaled to [0,1], each score is inversed and divided by maximum score value.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotModelRanking(lm_au, rf_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
