% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_from_rmds.R
\name{att_from_rmds}
\alias{att_from_rmds}
\alias{att_from_qmds}
\title{Get all packages called in vignettes folder}
\usage{
att_from_rmds(
  path = "vignettes",
  pattern = "*.[.](Rmd|rmd|qmd)$",
  recursive = TRUE,
  warn = -1,
  inside_rmd = FALSE,
  inline = TRUE
)

att_from_qmds(
  path = "vignettes",
  pattern = "*.[.](Rmd|rmd|qmd)$",
  recursive = TRUE,
  warn = -1,
  inside_rmd = FALSE,
  inline = TRUE
)
}
\arguments{
\item{path}{path to directory with Rmds or vector of Rmd files}

\item{pattern}{pattern to detect Rmd files}

\item{recursive}{logical. Should the listing recurse into directories?}

\item{warn}{-1 for quiet warnings with purl, 0 to see warnings}

\item{inside_rmd}{Logical. Whether function is run inside a Rmd,
in case this must be executed in an external R session}

\item{inline}{Logical. Default TRUE. Whether to explore inline code for dependencies.}
}
\value{
Character vector of packages called with library or require.
\emph{knitr} and \emph{rmarkdown} are added by default to allow building the vignettes
if the directory contains "vignettes" in the path
}
\description{
Get all packages called in vignettes folder
}
\examples{
dummypackage <- system.file("dummypackage",package = "attachment")
# browseURL(dummypackage)
att_from_rmds(path = file.path(dummypackage,"vignettes"))
}
