% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-spec-mort.R
\name{load_spec_mort}
\alias{load_spec_mort}
\title{Load mortality information from outputSpecificPredMort.txt}
\usage{
load_spec_mort(specmort, prm_run, fgs, convert_names = FALSE,
  version_flag = 2)
}
\arguments{
\item{specmort}{Character string giving the connection of the specific mortality file.
The filename usually contains \code{SpecificPredMort} and ends in \code{.txt}".}

\item{prm_run}{Character string giving the connection of the run parameterfile.
The filename usually contains \code{run_fishing} and ends in \code{.prm}".}

\item{fgs}{Character string giving the connection to the functional groups file.
The filename usually contains \code{Groups} and does end in \code{.csv}.}

\item{convert_names}{Logical indicating if group codes are transformed to LongNames (\code{TRUE})
or not (default = \code{FALSE}).}

\item{version_flag}{The version of ATLANTIS model. 1 for bec_dev, 2 for trunk. \code{default is 2.}.}
}
\value{
Dataframe with information about ssb in tonnes and recruits in
thousands.
}
\description{
Load mortality information from outputSpecificPredMort.txt
}
\examples{
d <- system.file("extdata", "setas-model-new-becdev", package = "atlantistools")
specmort <- file.path(d, "outputSETASSpecificPredMort.txt")
prm_run <- file.path(d, "VMPA_setas_run_fishing_F_New.prm")
fgs <- file.path(d, "SETasGroups.csv")

df <- load_spec_mort(specmort, prm_run, fgs, version_flag = 1)
head(df)

d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
specmort <- file.path(d, "outputSETASSpecificPredMort.txt")
prm_run <- file.path(d, "VMPA_setas_run_fishing_F_Trunk.prm")
fgs <- file.path(d, "SETasGroupsDem_NoCep.csv")

df <- load_spec_mort(specmort, prm_run, fgs)
head(df)
}
\seealso{
Other load functions: \code{\link{load_box}},
  \code{\link{load_bps}}, \code{\link{load_dietcheck}},
  \code{\link{load_fgs}}, \code{\link{load_init_age}},
  \code{\link{load_init}}, \code{\link{load_nc_physics}},
  \code{\link{load_nc}}, \code{\link{load_rec}},
  \code{\link{load_txt}}
}
