/*
 * Decompiled with CFR 0.152.
 */
package asymmetry;

public class SYMAT {
    public int nobs;
    double[] B;
    double number;
    int rows;
    int ik;
    int jk;
    int kk;

    public SYMAT(int n) {
        this.rows = n;
        this.B = new double[n * (n + 1) / 2];
    }

    public SYMAT(double[] A, int n) {
        this.rows = n;
        this.B = new double[n * (n + 1) / 2];
        this.ik = 0;
        while (this.ik < A.length) {
            this.B[this.ik] = A[this.ik];
            ++this.ik;
        }
    }

    public SYMAT(double[][] Mat) {
        this.nobs = Mat.length;
        this.rows = Mat[0].length;
        this.B = new double[this.rows * (this.rows + 1) / 2];
        this.ik = 0;
        while (this.ik < this.rows) {
            this.jk = this.ik;
            while (this.jk < this.rows) {
                this.number = 0.0;
                this.kk = 0;
                while (this.kk < Mat.length) {
                    this.number += Mat[this.kk][this.ik] * Mat[this.kk][this.jk];
                    ++this.kk;
                }
                this.setValue(this.ik, this.jk, this.number);
                ++this.jk;
            }
            ++this.ik;
        }
    }

    public SYMAT(double[][] Mat, boolean b) {
        this.nobs = Mat.length;
        this.rows = Mat[0].length + 1;
        this.B = new double[this.rows * (this.rows + 1) / 2];
        double[][] Mat2 = new double[Mat.length][Mat[0].length];
        for (int i = 0; i < Mat.length; ++i) {
            for (int j = 0; j < Mat[0].length; ++j) {
                Mat2[i][j] = Mat[i][j];
            }
        }
        this.kk = 0;
        while (this.kk < Mat.length) {
            this.jk = 1;
            while (this.jk <= Mat[0].length) {
                double d = Mat2[this.kk][this.jk - 1] - this.B[(this.jk + 1) * this.jk / 2];
                this.ik = this.jk;
                while (this.ik <= Mat[0].length) {
                    int n = (this.ik + 1) * this.ik / 2 + this.jk;
                    this.B[n] = this.B[n] + (double)this.kk * d * (Mat2[this.kk][this.ik - 1] - this.B[(this.ik + 1) * this.ik / 2]) / (double)(this.kk + 1);
                    ++this.ik;
                }
                ++this.jk;
            }
            this.jk = 0;
            while (this.jk < Mat[0].length) {
                this.B[(this.jk + 2) * (this.jk + 1) / 2] = ((double)this.kk * this.B[(this.jk + 2) * (this.jk + 1) / 2] + Mat2[this.kk][this.jk]) / (double)(this.kk + 1);
                ++this.jk;
            }
            ++this.kk;
        }
        this.B[0] = this.B[0] * (-1.0 / (double)Mat.length);
    }

    public final int getRowDimension() {
        return this.rows;
    }

    public final int getLength() {
        return this.B.length;
    }

    public final void setValue(int i, int j, double val) {
        if (i > j) {
            this.B[(i + 1) * i / 2 + j] = val;
            return;
        }
        this.B[(j + 1) * j / 2 + i] = val;
    }

    public final void addValue(int i, int j, double val) {
        if (i > j) {
            int n = (i + 1) * i / 2 + j;
            this.B[n] = this.B[n] + val;
            return;
        }
        int n = (j + 1) * j / 2 + i;
        this.B[n] = this.B[n] + val;
    }

    public final void multiply(int i, int j, double val) {
        if (i > j) {
            int n = (i + 1) * i / 2 + j;
            this.B[n] = this.B[n] * val;
            return;
        }
        int n = (j + 1) * j / 2 + i;
        this.B[n] = this.B[n] * val;
    }

    public final void setzero() {
        this.ik = 0;
        while (this.ik < this.B.length) {
            this.B[this.ik] = 0.0;
            ++this.ik;
        }
    }

    public double[] getArray() {
        double[] C = new double[this.B.length];
        this.ik = 0;
        while (this.ik < this.B.length) {
            C[this.ik] = this.B[this.ik];
            ++this.ik;
        }
        return C;
    }

    public final double getValue(int i, int j) {
        this.number = i > j ? this.B[(i + 1) * i / 2 + j] : this.B[(j + 1) * j / 2 + i];
        return this.number;
    }

    public String toString() {
        String s = "";
        this.ik = 0;
        while (this.ik < this.rows) {
            this.jk = this.ik;
            while (this.jk < this.rows) {
                s = s + this.getValue(this.ik, this.jk) + "  ";
                ++this.jk;
            }
            s = s + "\n";
            ++this.ik;
        }
        return s;
    }

    public final int getnobs() {
        return this.nobs;
    }
}

