% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-r-mode.R, R/is-r-mode.R
\name{assert_is_batch_mode}
\alias{assert_is_batch_mode}
\alias{assert_is_interactive}
\alias{assert_is_r_slave}
\alias{assert_is_slave_r}
\alias{is_batch_mode}
\alias{is_interactive}
\alias{is_r_slave}
\alias{is_slave_r}
\title{How is R running?}
\usage{
assert_is_batch_mode(severity = getOption("assertive.severity", "stop"))

assert_is_interactive(severity = getOption("assertive.severity", "stop"))

assert_is_r_slave(severity = getOption("assertive.severity", "stop"))

assert_is_slave_r(severity = getOption("assertive.severity", "stop"))

is_batch_mode()

is_interactive()

is_r_slave()

is_slave_r()
}
\arguments{
\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{is_batch_mode} returns \code{TRUE} if R is running in batch 
mode.
\code{is_interactive} returns \code{TRUE} if R is running interactively.
}
\description{
Tests to see if R is running in batch mode/interactively.
}
\examples{
is_batch_mode()
is_interactive()
is_r_slave()
}
\seealso{
\code{\link[base]{EnvVar}} and \code{\link[base]{interactive}}.
}

