% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-file.R, R/is-file.R
\name{assert_all_are_dirs}
\alias{assert_all_are_dirs}
\alias{assert_any_are_dirs}
\alias{is_dir}
\title{Is the path a directory?
Checks to see if the input path is a directory.}
\usage{
assert_all_are_dirs(x, severity = getOption("assertive.severity", "stop"))

assert_any_are_dirs(x, severity = getOption("assertive.severity", "stop"))

is_dir(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{File paths.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_dir} returns \code{TRUE} if and only if the input
path is a directory that exists, as determined by \code{file.info}.
}
\description{
Is the path a directory?
Checks to see if the input path is a directory.
}
\examples{
assert_all_are_dirs(R.home())
}

