% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/coercion.R
\name{is2}
\alias{is2}
\title{Alternative version of is}
\usage{
is2(x, class, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{class}{Target class that \code{x} maybe belong to.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{TRUE} if x belongs to the class and \code{FALSE}
otherwise.
}
\description{
If a function named \code{is.class} exists, call \code{is.class(x)}.
If not, call \code{is(x, class)}.
}
\examples{
is2(1:5, "character")
is2(matrix(1:5), "character")
is2(1:5, c("character", "list", "numeric"))
}
\seealso{
\code{\link[methods]{is}}, and
\code{\link[assertive]{assert_is_all_of}} for the corresponding assert fns.
}

