*-------------------------------------------------------------------------*
|              SAS DATA DEFINITION STATEMENTS FOR ICPSR 9028              |
|                                                                         |
|          UNIFORM CRIME REPORTING PROGRAM DATA: [UNITED STATES]          |
|                                                                         |
|               Part 57: Supplementary Homicide Report, 1987              |
|                                                                         |
|                                                                         |
| This SAS setup file contains the following statements:                  |
|                                                                         |
| PROC FORMAT:  Creates user-defined formats. Formats replace original    |
| value codes with value code descriptions. Formats may not be present    |
| for all variables in the data file.                                     |
|                                                                         |
| DATA:  Begins a SAS data step and names an output SAS data set.         |
|                                                                         |
| INFILE:  Specifies the input data file to be read with the input        |
| statement. Users must replace "file-specification" with a complete      |
| statement of the location of the data file.                             |
|                                                                         |
| INPUT:  Assigns the name, type, decimal specification (if any), and     |
| identifies variable beginning and ending column locations.              |
|                                                                         |
| LABEL:  Assigns descriptive labels to variables. Variable labels and    |
| variable names may be identical for certain variables.                  |
|                                                                         |
| FORMAT:  Associates the formats created by the PROC FORMAT step with    |
| the variables named in the INPUT statement. Format statements may not   |
| be present for all variables in the data file.                          |
|                                                                         |
| MISSING VALUE RECODES:  Sets user-defined numeric missing values to     |
| missing as interpreted by the SAS system. Missing value recodes may not |
| be present for all variables in the data file.                          |
|                                                                         |
| NOTE:  Users should modify this SAS setup file to suit their specific   |
| needs. PROC FORMAT, FORMAT, and MISSING VALUE RECODES sections have     |
| been marked by SAS comment statements. To include these sections in a   |
| final SAS setup, users should remove the SAS comment statements from    |
| the desired section(s).                                                 |
*-------------------------------------------------------------------------;
                                                                           
* SAS PROC FORMAT;                                                         
/*                                                                         
PROC FORMAT;                                                               
   VALUE V1FT (MAX=40)                                                     
   9028 = "STUDY NUMBER";                                                  
   VALUE V2FT (MAX=40)                                                     
   1 = "JUNE 1990";                                                        
   VALUE V5FT (MAX=40)                                                     
   1 = "ALABAMA"                                                           
   2 = "ARIZONA"                                                           
   3 = "ARKANSAS"                                                          
   4 = "CALIFORNIA"                                                        
   5 = "COLORADO"                                                          
   6 = "CONNECTICUT"                                                       
   7 = "DELAWARE"                                                          
   8 = "WASHINGTON, D.C"                                                   
   9 = "FLORIDA"                                                           
   10 = "GEORGIA"                                                          
   11 = "IDAHO"                                                            
   12 = "ILLINOIS"                                                         
   13 = "INDIANA"                                                          
   14 = "IOWA"                                                             
   15 = "KANSAS"                                                           
   16 = "KENTUCKY"                                                         
   17 = "LOUISIANA"                                                        
   18 = "MAINE"                                                            
   19 = "MARYLAND"                                                         
   20 = "MASSACHUSETTS"                                                    
   21 = "MICHIGAN"                                                         
   22 = "MINNESOTA"                                                        
   23 = "MISSISSIPPI"                                                      
   24 = "MISSOURI"                                                         
   25 = "MONTANA"                                                          
   26 = "NEBRASKA"                                                         
   27 = "NEVADA"                                                           
   28 = "NEW HAMPSHIRE"                                                    
   29 = "NEW JERSEY"                                                       
   30 = "NEW MEXICO"                                                       
   31 = "NEW YORK"                                                         
   32 = "NORTH CAROLINA"                                                   
   33 = "NORTH DAKOTA"                                                     
   34 = "OHIO"                                                             
   35 = "OKLAHOMA"                                                         
   36 = "OREGON"                                                           
   37 = "PENNSYLVANIA"                                                     
   38 = "RHODE ISLAND"                                                     
   39 = "SOUTH CAROLINA"                                                   
   40 = "SOUTH DAKOTA"                                                     
   41 = "TENNESSEE"                                                        
   42 = "TEXAS"                                                            
   43 = "UTAH"                                                             
   44 = "VERMONT"                                                          
   45 = "VIRGINIA"                                                         
   46 = "WASHINGTON"                                                       
   47 = "WEST VIRGINIA"                                                    
   48 = "WISCONSIN"                                                        
   49 = "WYOMING"                                                          
   50 = "ALASKA"                                                           
   51 = "HAWAII";                                                          
   VALUE V7FT (MAX=40)                                                     
   0 = "POSSESSIONS"                                                       
   1 = "ALL CITIES 250K+"                                                  
   2 = "CIT BT 100K-250K"                                                  
   3 = "CITI BET 50K-99K"                                                  
   4 = "CITS BET 25K-50K"                                                  
   5 = "CITI BET 10K-25K"                                                  
   6 = "CIT BT 2.5K-9.9K"                                                  
   7 = "CITIE UNDER 2.5K"                                                  
   8 = "NON-MSA CNTIES"                                                    
   9 = "MSA COUNTIES";                                                     
   VALUE V8FT (MAX=40)                                                     
   11 = "ALL CITIES 1M+"                                                   
   12 = "CIT BT 500K-999K"                                                 
   13 = "CIT BET 250-500K"                                                 
   20 = "CIT BT 100K-250K"                                                 
   30 = "CITI BT 50K-100K"                                                 
   40 = "CITIE BT 25K-50K"                                                 
   50 = "CITIE BT 10K-25K"                                                 
   60 = "CIT BET 2.5K-10K"                                                 
   70 = "CITIE UNDER 2.5K"                                                 
   81 = "NON-MSA 100K+"                                                    
   82 = "NON-MSA 25K-100K"                                                 
   83 = "NON-MSA 10K-25K"                                                  
   84 = "NON-MSA <10K"                                                     
   91 = "MSA 100K+"                                                        
   92 = "MSA 25K-100K"                                                     
   93 = "MSA 10K-25K"                                                      
   94 = "MSA COUNT <10K";                                                  
   VALUE V9FT (MAX=40)                                                     
   1 = "NEW ENGLND STS"                                                    
   2 = "MID-ATL STATES"                                                    
   3 = "E N.CENT STATES"                                                   
   4 = "W N.CENT STATES"                                                   
   5 = "STH ATL STATES"                                                    
   6 = "E S.CENT STATES"                                                   
   7 = "W S.CENT STATES"                                                   
   8 = "MOUNTAIN STATES"                                                   
   9 = "PACIFIC STATES";                                                   
   VALUE V12FT (MAX=40)                                                    
   0 = "INAP";                                                             
   VALUE V13FT (MAX=40)                                                    
   0 = "INAP";                                                             
   VALUE V14FT (MAX=40)                                                    
   0 = "NON-SUBURBAN"                                                      
   1 = "SUBURBAN";                                                         
   VALUE V17FT (MAX=40)                                                    
   1 = "JANUARY"                                                           
   2 = "FEBRUARY"                                                          
   3 = "MARCH"                                                             
   4 = "APRIL"                                                             
   5 = "MAY"                                                               
   6 = "JUNE"                                                              
   7 = "JULY"                                                              
   8 = "AUGUST"                                                            
   9 = "SEPTEMBER"                                                         
   10 = "OCTOBER"                                                          
   11 = "NOVEMBER"                                                         
   12 = "DECEMBER";                                                        
   VALUE V19FT (MAX=40)                                                    
   0 = "NORMAL UPDATE"                                                     
   1 = "ADJUSTMENT";                                                       
   VALUE V20FT (MAX=40)                                                    
   1 = "MURDER NONNEGLIG"                                                  
   2 = "MANSL BY NEGLIG";                                                  
   VALUE V22FT (MAX=40)                                                    
   1 = "SNGL VICT-1 OFFE"                                                  
   2 = "SNGL VIC UNK OFF"                                                  
   3 = "SINGL VIC-MUL OF"                                                  
   4 = "MULT VIC-SIN OFF"                                                  
   5 = "MULTIPLE VIC-OFF"                                                  
   6 = "MULT VIC-UNK OFF";                                                 
   VALUE V25FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE";                                                  
   VALUE V26FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   9 = "UNKNOWN";                                                          
   VALUE V27FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V28FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V29FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V30FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V31FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V32FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V33FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V34FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V35FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V36FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V37FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V38FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V39FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V40FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V41FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V42FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V43FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V44FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V45FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V46FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V47FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V48FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V49FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V50FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V51FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V52FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V53FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V54FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V55FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V56FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V57FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V58FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V59FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V60FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V61FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V62FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V63FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V64FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V65FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V66FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V67FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V68FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V69FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE";                                                  
   VALUE V70FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   9 = "UNKNOWN";                                                          
   VALUE V71FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V72FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V73FT (MAX=40)                                                    
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE-CUT INST"                                                   
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK";                                                   
   VALUE V74FT (MAX=40)                                                    
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   99 = "REL NOT DETERMND";                                                
   VALUE V75FT (MAX=40)                                                    
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   20 = "ABORTION"                                                         
   26 = "OTH -FELONY TYPE"                                                 
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FEL TYPE"                                                 
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOMI-POLI"                                                 
   99 = "REL NOT DETERMND";                                                
   VALUE V76FT (MAX=40)                                                    
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLD DURING CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   9 = "INAP";                                                             
   VALUE V77FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V78FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V79FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP"                                                              
   9 = "UNKNOWN";                                                          
   VALUE V80FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V81FT (MAX=40)                                                    
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK"                                                    
   99 = "INAP";                                                            
   VALUE V82FT (MAX=40)                                                    
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V83FT (MAX=40)                                                    
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V84FT (MAX=40)                                                    
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP  1 OFFNDR"                                                    
   9 = "INAP  JUSTIFABLE";                                                 
   VALUE V85FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V86FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V87FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V88FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V89FT (MAX=40)                                                    
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK"                                                    
   99 = "INAP";                                                            
   VALUE V90FT (MAX=40)                                                    
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V91FT (MAX=40)                                                    
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V92FT (MAX=40)                                                    
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "INAP JUSTIF HOM";                                                  
   VALUE V93FT (MAX=40)                                                    
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V94FT (MAX=40)                                                    
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V95FT (MAX=40)                                                    
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V96FT (MAX=40)                                                    
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V97FT (MAX=40)                                                    
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK"                                                    
   99 = "INAP";                                                            
   VALUE V98FT (MAX=40)                                                    
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V99FT (MAX=40)                                                    
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V100FT (MAX=40)                                                   
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "INAP JUSTIF HOM";                                                  
   VALUE V101FT (MAX=40)                                                   
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V102FT (MAX=40)                                                   
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V103FT (MAX=40)                                                   
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V104FT (MAX=40)                                                   
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V105FT (MAX=40)                                                   
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK";                                                   
   VALUE V106FT (MAX=40)                                                   
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V107FT (MAX=40)                                                   
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V108FT (MAX=40)                                                   
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "INAP JUSTIF HOM";                                                  
   VALUE V109FT (MAX=40)                                                   
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V110FT (MAX=40)                                                   
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V111FT (MAX=40)                                                   
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V112FT (MAX=40)                                                   
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V113FT (MAX=40)                                                   
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK"                                                    
   99 = "INAP";                                                            
   VALUE V114FT (MAX=40)                                                   
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V115FT (MAX=40)                                                   
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V116FT (MAX=40)                                                   
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "INAP JUSTIF HOM";                                                  
   VALUE V117FT (MAX=40)                                                   
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V118FT (MAX=40)                                                   
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V119FT (MAX=40)                                                   
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V120FT (MAX=40)                                                   
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V121FT (MAX=40)                                                   
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK"                                                    
   99 = "INAP";                                                            
   VALUE V122FT (MAX=40)                                                   
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V123FT (MAX=40)                                                   
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V124FT (MAX=40)                                                   
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "INAP JUSTIF HOM";                                                  
   VALUE V125FT (MAX=40)                                                   
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V126FT (MAX=40)                                                   
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V127FT (MAX=40)                                                   
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V128FT (MAX=40)                                                   
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V129FT (MAX=40)                                                   
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK"                                                    
   99 = "INAP";                                                            
   VALUE V130FT (MAX=40)                                                   
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V131FT (MAX=40)                                                   
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V132FT (MAX=40)                                                   
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "INAP JUSTIF HOM";                                                  
   VALUE V133FT (MAX=40)                                                   
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V134FT (MAX=40)                                                   
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V135FT (MAX=40)                                                   
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V136FT (MAX=40)                                                   
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V137FT (MAX=40)                                                   
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK"                                                    
   99 = "INAP";                                                            
   VALUE V138FT (MAX=40)                                                   
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V139FT (MAX=40)                                                   
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V140FT (MAX=40)                                                   
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "INAP JUSTIF HOM";                                                  
   VALUE V141FT (MAX=40)                                                   
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V142FT (MAX=40)                                                   
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V143FT (MAX=40)                                                   
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V144FT (MAX=40)                                                   
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V145FT (MAX=40)                                                   
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK"                                                    
   99 = "INAP";                                                            
   VALUE V146FT (MAX=40)                                                   
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V147FT (MAX=40)                                                   
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V148FT (MAX=40)                                                   
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "INAP JUSTIF HOM";                                                  
   VALUE V149FT (MAX=40)                                                   
   0 = "AGE UNKNOWN"                                                       
   1 = "BIRTH TO 1 YEAR"                                                   
   99 = "99 YRS OR MORE"                                                   
   999 = "INAP";                                                           
   VALUE V150FT (MAX=40)                                                   
   1 = "MALE"                                                              
   2 = "FEMALE"                                                            
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V151FT (MAX=40)                                                   
   1 = "WHITE"                                                             
   2 = "BLACK"                                                             
   3 = "AMERICAN INDIAN"                                                   
   4 = "ASIAN-PAC ISLAND"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "UNKNOWN";                                                          
   VALUE V152FT (MAX=40)                                                   
   1 = "HISPANIC ORIGIN"                                                   
   2 = "NOT HISPANIC"                                                      
   9 = "UNKNOWN-NOT REPT";                                                 
   VALUE V153FT (MAX=40)                                                   
   11 = "FIREARM,TYPE UNK"                                                 
   12 = "HANDGUN-PSTL,ETC"                                                 
   13 = "RIFLE"                                                            
   14 = "SHOTGUN"                                                          
   15 = "OTHER GUN"                                                        
   20 = "KNIFE - CUTTING"                                                  
   30 = "BLUNT OBJECT"                                                     
   40 = "PERSONAL WEAPONS"                                                 
   50 = "POISON - NOT GAS"                                                 
   55 = "PUSHD OUT WNDW"                                                   
   60 = "EXPLOSIVES"                                                       
   65 = "FIRE"                                                             
   70 = "NARCOTICS DRUGS"                                                  
   75 = "DROWNING"                                                         
   80 = "STRANGULATN-HANG"                                                 
   85 = "ASPHYXIATION-GAS"                                                 
   90 = "OTH -TYPE UNK"                                                    
   99 = "INAP";                                                            
   VALUE V154FT (MAX=40)                                                   
   1 = "HUSBAND"                                                           
   2 = "WIFE"                                                              
   3 = "COMMON-LAW HUSB"                                                   
   4 = "COMMON-LAW WIFE"                                                   
   5 = "MOTHER"                                                            
   6 = "FATHER"                                                            
   7 = "SON"                                                               
   8 = "DAUGHTER"                                                          
   9 = "BROTHER"                                                           
   10 = "SISTER"                                                           
   11 = "IN-LAW"                                                           
   12 = "STEPFATHER"                                                       
   13 = "STEPMOTHER"                                                       
   14 = "STEPSON"                                                          
   15 = "STEPDAUGHTER"                                                     
   16 = "OTHER FAMILY"                                                     
   17 = "NEIGHBOR"                                                         
   18 = "ACQUAINTANCE"                                                     
   19 = "BOYFRIEND"                                                        
   20 = "GIRLFRIEND"                                                       
   21 = "EX-HUSBAND"                                                       
   22 = "EX-WIFE"                                                          
   23 = "EMPLOYEE"                                                         
   24 = "EMPLOYER"                                                         
   25 = "FRIEND"                                                           
   26 = "HOMOSEXUAL RELAT"                                                 
   27 = "OTH-VIC KNOWS"                                                    
   28 = "STRANGER"                                                         
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V155FT (MAX=40)                                                   
   2 = "RAPE"                                                              
   3 = "ROBBERY"                                                           
   5 = "BURGLARY"                                                          
   6 = "LARCENY"                                                           
   7 = "MOTOR VEHI THEFT"                                                  
   9 = "ARSON"                                                             
   10 = "PROSTIT,COM-VICE"                                                 
   17 = "OTH SEX OFFENSE"                                                  
   18 = "NARC DRUG LAW"                                                    
   19 = "GAMBLING"                                                         
   26 = "OTH FELONY TYPE"                                                  
   32 = "ABORTION"                                                         
   40 = "LOVER-S TRIANGLE"                                                 
   41 = "SITTER KLLD CHLD"                                                 
   42 = "BRAWL-ALCOHOL"                                                    
   43 = "BRAWL-NARCOTICS"                                                  
   44 = "ARGUMENT - MONEY"                                                 
   45 = "OTHER ARGUMENTS"                                                  
   46 = "GANGLAND KLLINGS"                                                 
   47 = "JUV GANG KILLNGS"                                                 
   48 = "INSTITUT KILLNGS"                                                 
   49 = "SNIPER ATTACK"                                                    
   50 = "VIC SHOT HUNT AC"                                                 
   51 = "GUN-CLEANING DTH"                                                 
   52 = "KIDS PLAY WITH GUN"                                               
   53 = "OTH NEGLIGEN-GUN"                                                 
   59 = "ALL OTH MANSLAUG"                                                 
   60 = "OTH NON-FELONY"                                                   
   70 = "ALL SUSPECT FELO"                                                 
   80 = "JUSTIF HOMI-CIVIL"                                                
   81 = "JUSTIF HOM-POLIC"                                                 
   98 = "INAP"                                                             
   99 = "REL NOT DETERMND";                                                
   VALUE V156FT (MAX=40)                                                   
   1 = "FEL ATTACK POLIC"                                                  
   2 = "FEL ATTACK POLIC"                                                  
   3 = "FEL ATTACK PERS"                                                   
   4 = "FEL ATTEM FLIGHT"                                                  
   5 = "KILLED DURNG CRM"                                                  
   6 = "FEL RESIST ARRES"                                                  
   7 = "NOT ENOUGH INFOR"                                                  
   8 = "INAP FEWR OFFNDS"                                                  
   9 = "INAP JUSTIF HOM";*/                                                
                                                                           
* SAS DATA, INFILE, INPUT STATEMENTS;                                      
                                                                           
DATA;                                                                      
INFILE "file-specification" LRECL=299;                                     
INPUT                                                                      
   V1 1-4                   V2 5-5                   V3 6-7                
   V4 8-12                  V5 13-14                 V6 $ 15-21            
   V7 22-22                 V8 23-24                 V9 25-25              
   V10 26-27                V11 28-35                V12 36-38             
   V13 39-41                V14 42-42                V15 $ 43-66           
   V16 $ 67-72              V17 73-74                V18 75-80             
   V19 81-81                V20 82-82                V21 83-85             
   V22 86-86                V23 87-88                V24 89-90             
   V25 91-93                V26 94-94                V27 95-95             
   V28 96-96                V29 97-99                V30 100-100           
   V31 101-101              V32 102-102              V33 103-105           
   V34 106-106              V35 107-107              V36 108-108           
   V37 109-111              V38 112-112              V39 113-113           
   V40 114-114              V41 115-117              V42 118-118           
   V43 119-119              V44 120-120              V45 121-123           
   V46 124-124              V47 125-125              V48 126-126           
   V49 127-129              V50 130-130              V51 131-131           
   V52 132-132              V53 133-135              V54 136-136           
   V55 137-137              V56 138-138              V57 139-141           
   V58 142-142              V59 143-143              V60 144-144           
   V61 145-147              V62 148-148              V63 149-149           
   V64 150-150              V65 151-153              V66 154-154           
   V67 155-155              V68 156-156              V69 157-159           
   V70 160-160              V71 161-161              V72 162-162           
   V73 163-164              V74 165-166              V75 167-168           
   V76 169-169              V77 170-172              V78 173-173           
   V79 174-174              V80 175-175              V81 176-177           
   V82 178-179              V83 180-181              V84 182-182           
   V85 183-185              V86 186-186              V87 187-187           
   V88 188-188              V89 189-190              V90 191-192           
   V91 193-194              V92 195-195              V93 196-198           
   V94 199-199              V95 200-200              V96 201-201           
   V97 202-203              V98 204-205              V99 206-207           
   V100 208-208             V101 209-211             V102 212-212          
   V103 213-213             V104 214-214             V105 215-216          
   V106 217-218             V107 219-220             V108 221-221          
   V109 222-224             V110 225-225             V111 226-226          
   V112 227-227             V113 228-229             V114 230-231          
   V115 232-233             V116 234-234             V117 235-237          
   V118 238-238             V119 239-239             V120 240-240          
   V121 241-242             V122 243-244             V123 245-246          
   V124 247-247             V125 248-250             V126 251-251          
   V127 252-252             V128 253-253             V129 254-255          
   V130 256-257             V131 258-259             V132 260-260          
   V133 261-263             V134 264-264             V135 265-265          
   V136 266-266             V137 267-268             V138 269-270          
   V139 271-272             V140 273-273             V141 274-276          
   V142 277-277             V143 278-278             V144 279-279          
   V145 280-281             V146 282-283             V147 284-285          
   V148 286-286             V149 287-289             V150 290-290          
   V151 291-291             V152 292-292             V153 293-294          
   V154 295-296             V155 297-298             V156 299-299;         
                                                                           
* SAS LABEL STATEMENT;                                                     
                                                                           
LABEL                                                                      
   V1 = "ICPSR STUDY NUMBER-9028"                                          
   V2 = "ICPSR VERSION NUMBER-1"                                           
   V3 = "ICPSR PART NUMBER"                                                
   V4 = "ICPSR SEQUENTIAL ID"                                              
   V5 = "NUMERIC STATE CODE"                                               
   V6 = "AGENCY CODE"                                                      
   V7 = "GROUP"                                                            
   V8 = "SUB GROUP"                                                        
   V9 = "GEOGRAPHIC DIVISION"                                              
   V10 = "YEAR"                                                            
   V11 = "POPULATION"                                                      
   V12 = "COUNTY"                                                          
   V13 = "MSA CODE"                                                        
   V14 = "MSA INDICATION"                                                  
   V15 = "AGENCY NAME"                                                     
   V16 = "AGENCY STATE"                                                    
   V17 = "MONTH OF OFFENSE"                                                
   V18 = "LAST UPDATE"                                                     
   V19 = "TYPE OF ACTION"                                                  
   V20 = "TYPE OF OFFENSE -HOMICD-"                                        
   V21 = "INCIDENT NUMBER"                                                 
   V22 = "SITUATION"                                                       
   V23 = "VICTIM COUNT - ADDL VICT"                                        
   V24 = "OFFNDR COUNT - ADD-L"                                            
   V25 = "VICTIM 1: AGE"                                                   
   V26 = "VICTIM 1: SEX"                                                   
   V27 = "VICTIM 1: RACE"                                                  
   V28 = "VICTIM 1: ETHNIC ORIGIN"                                         
   V29 = "VICTIM 2: AGE"                                                   
   V30 = "VICTIM 2: SEX"                                                   
   V31 = "VICTIM 2: RACE"                                                  
   V32 = "VICTIM 2: ETHNIC ORIGIN"                                         
   V33 = "VICTIM 3: AGE"                                                   
   V34 = "VICTIM 3: SEX"                                                   
   V35 = "VICTIM 3: RACE"                                                  
   V36 = "VICTIM 3: ETHNIC ORIGIN"                                         
   V37 = "VICTIM 4: AGE"                                                   
   V38 = "VICTIM 4: SEX"                                                   
   V39 = "VICTIM 4: RACE"                                                  
   V40 = "VICTIM 4: ETHNIC ORIGIN"                                         
   V41 = "VICTIM 5: AGE"                                                   
   V42 = "VICTIM 5: SEX"                                                   
   V43 = "VICTIM 5: RACE"                                                  
   V44 = "VICTIM 5: ETHNIC ORIGIN"                                         
   V45 = "VICTIM 6: AGE"                                                   
   V46 = "VICTIM 6: SEX"                                                   
   V47 = "VICTIM 6: RACE"                                                  
   V48 = "VICTIM 6: ETHNIC ORIGIN"                                         
   V49 = "VICTIM 7: AGE"                                                   
   V50 = "VICTIM 7: SEX"                                                   
   V51 = "VICTIM 7: RACE"                                                  
   V52 = "VICTIM 7: ETHNIC ORIGIN"                                         
   V53 = "VICTIM 8: AGE"                                                   
   V54 = "VICTIM 8: SEX"                                                   
   V55 = "VICTIM 8: RACE"                                                  
   V56 = "VICTIM 8: ETHNIC ORIGIN"                                         
   V57 = "VICTIM 9: AGE"                                                   
   V58 = "VICTIM 9: SEX"                                                   
   V59 = "VICTIM 9: RACE"                                                  
   V60 = "VICTIM 9: ETHNIC ORIGIN"                                         
   V61 = "VICTIM 10: AGE"                                                  
   V62 = "VICTIM 10: SEX"                                                  
   V63 = "VICTIM 10: RACE"                                                 
   V64 = "VICTIM 10: ETHNIC ORIGIN"                                        
   V65 = "VICTIM 11: AGE"                                                  
   V66 = "VICTIM 11: SEX"                                                  
   V67 = "VICTIM 11: RACE"                                                 
   V68 = "VICTIM 11: ETHNIC ORIGIN"                                        
   V69 = "OFFENDER 1: AGE"                                                 
   V70 = "OFFENDER 1: SEX"                                                 
   V71 = "OFFENDER 1: RACE"                                                
   V72 = "OFFENDER 1: ETHNC ORIGIN"                                        
   V73 = "OFFENDER 1: WEAPON"                                              
   V74 = "OFFENDER 1: RELATIONSHIP"                                        
   V75 = "OFFENDER 1: CIRCUMSTANCE"                                        
   V76 = "OFFENDER 1: SUBCIRCUMST"                                         
   V77 = "OFFENDER 2: AGE"                                                 
   V78 = "OFFENDER 2: SEX"                                                 
   V79 = "OFFENDER 2: RACE"                                                
   V80 = "OFFENDER 2: ETHNC ORIGIN"                                        
   V81 = "OFFENDER 2: WEAPON"                                              
   V82 = "OFFENDER 2: RELATIONSHIP"                                        
   V83 = "OFFENDER 2: CIRCUMSTNCES"                                        
   V84 = "OFFENDER 2: SUBCIRCUM"                                           
   V85 = "OFFENDER 3: AGE"                                                 
   V86 = "OFFENDER 3: SEX"                                                 
   V87 = "OFFENDER 3: RACE"                                                
   V88 = "OFFENDER 3: ETHNC ORIGIN"                                        
   V89 = "OFFENDER 3: WEAPON"                                              
   V90 = "OFFENDER 3: RELATIONSHIP"                                        
   V91 = "OFFENDER 3: CIRCUMSTNCES"                                        
   V92 = "OFFENDER 3: SUBCIRCUM"                                           
   V93 = "OFFENDER 4: AGE"                                                 
   V94 = "OFFENDER 4: SEX"                                                 
   V95 = "OFFENDER 4: RACE"                                                
   V96 = "OFFENDER 4: ETHNC ORIGIN"                                        
   V97 = "OFFENDER 4: WEAPON"                                              
   V98 = "OFFENDER 4: RELATIONSHIP"                                        
   V99 = "OFFENDER 4: CIRCUMSTNCES"                                        
   V100 = "OFFENDER 4: SUBCIRCUM"                                          
   V101 = "OFFENDER 5: AGE"                                                
   V102 = "OFFENDER 5: SEX"                                                
   V103 = "OFFENDER 5: RACE"                                               
   V104 = "OFFENDER 5: ETHNC ORIGIN"                                       
   V105 = "OFFENDER 5: WEAPON"                                             
   V106 = "OFFENDER 5: RELATIONSHIP"                                       
   V107 = "OFFENDER 5: CIRCUMSTNCES"                                       
   V108 = "OFFENDER 5: SUBCIRCUM"                                          
   V109 = "OFFENDER 6: AGE"                                                
   V110 = "OFFENDER 6: SEX"                                                
   V111 = "OFFENDER 6: RACE"                                               
   V112 = "OFFENDER 6: ETHNC ORIGIN"                                       
   V113 = "OFFENDER 6: WEAPON"                                             
   V114 = "OFFENDER 6: RELATIONSHIP"                                       
   V115 = "OFFENDER 6: CIRCUMSTNCES"                                       
   V116 = "OFFENDER 6: SUBCIRCUM"                                          
   V117 = "OFFENDER 7: AGE"                                                
   V118 = "OFFENDER 7: SEX"                                                
   V119 = "OFFENDER 7: RACE"                                               
   V120 = "OFFENDER 7: ETHNC ORIGIN"                                       
   V121 = "OFFENDER 7: WEAPON"                                             
   V122 = "OFFENDER 7: RELATIONSHIP"                                       
   V123 = "OFFENDER 7: CIRCUMSTNCES"                                       
   V124 = "OFFENDER 7: SUBCIRCUM"                                          
   V125 = "OFFENDER 8: AGE"                                                
   V126 = "OFFENDER 8: SEX"                                                
   V127 = "OFFENDER 8: RACE"                                               
   V128 = "OFFENDER 8: ETHNC ORIGIN"                                       
   V129 = "OFFENDER 8: WEAPON"                                             
   V130 = "OFFENDER 8: RELATIONSHIP"                                       
   V131 = "OFFENDER 8: CIRCUMSTNCES"                                       
   V132 = "OFFENDER 8: SUBCIRCUM"                                          
   V133 = "OFFENDER 9: AGE"                                                
   V134 = "OFFENDER 9: SEX"                                                
   V135 = "OFFENDER 9: RACE"                                               
   V136 = "OFFENDER 9: ETHNC ORIGIN"                                       
   V137 = "OFFENDER 9: WEAPON"                                             
   V138 = "OFFENDER 9: RELATIONSHIP"                                       
   V139 = "OFFENDER 9: CIRCUMSTNCES"                                       
   V140 = "OFFENDER 9: SUBCIRCUM"                                          
   V141 = "OFFENDER 10: AGE"                                               
   V142 = "OFFENDER 10: SEX"                                               
   V143 = "OFFENDER 10: RACE"                                              
   V144 = "OFFENDER 10: ETHNC ORGIN"                                       
   V145 = "OFFENDER 10: WEAPON"                                            
   V146 = "OFFENDER 10: RELATIONSHP"                                       
   V147 = "OFFENDER 10: CIRCUMSTNCS"                                       
   V148 = "OFFENDER 10: SUBCIRCUM"                                         
   V149 = "OFFENDER 11: AGE"                                               
   V150 = "OFFENDER 11: SEX"                                               
   V151 = "OFFENDER 11: RACE"                                              
   V152 = "OFFENDER 11: ETHNC ORGIN"                                       
   V153 = "OFFENDER 11: WEAPON"                                            
   V154 = "OFFENDER 11: RELATIONSHP"                                       
   V155 = "OFFENDER 11: CIRCUMSTNCS"                                       
   V156 = "OFFENDER 11: SUBCIRCUM";                                        
                                                                           
* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;                         
                                                                           
/*                                                                         
   IF V12=0 THEN V12=.;                IF V13=0 THEN V13=.;                
   IF V25=0 THEN V25=.;                IF V26=9 THEN V26=.;                
   IF V27=9 THEN V27=.;                IF V28=9 THEN V28=.;                
   IF V29 IN (0, 999) THEN V29=.;      IF V30 IN (8, 9) THEN V30=.;        
   IF V31 IN (8, 9) THEN V31=.;        IF V32=9 THEN V32=.;                
   IF V33 IN (0, 999) THEN V33=.;      IF V34 IN (8, 9) THEN V34=.;        
   IF V35 IN (8, 9) THEN V35=.;        IF V36=9 THEN V36=.;                
   IF V37 IN (0, 999) THEN V37=.;      IF V38 IN (8, 9) THEN V38=.;        
   IF V39 IN (8, 9) THEN V39=.;        IF V40=9 THEN V40=.;                
   IF V41 IN (0, 999) THEN V41=.;      IF V42 IN (8, 9) THEN V42=.;        
   IF V43 IN (8, 9) THEN V43=.;        IF V44=9 THEN V44=.;                
   IF V45 IN (0, 999) THEN V45=.;      IF V46 IN (8, 9) THEN V46=.;        
   IF V47 IN (8, 9) THEN V47=.;        IF V48=9 THEN V48=.;                
   IF V49 IN (0, 999) THEN V49=.;      IF V50 IN (8, 9) THEN V50=.;        
   IF V51 IN (8, 9) THEN V51=.;        IF V52=9 THEN V52=.;                
   IF V53 IN (0, 999) THEN V53=.;      IF V54 IN (8, 9) THEN V54=.;        
   IF V55 IN (8, 9) THEN V55=.;        IF V56=9 THEN V56=.;                
   IF V57 IN (0, 999) THEN V57=.;      IF V58 IN (8, 9) THEN V58=.;        
   IF V59 IN (8, 9) THEN V59=.;        IF V60=9 THEN V60=.;                
   IF V61 IN (0, 999) THEN V61=.;      IF V62 IN (8, 9) THEN V62=.;        
   IF V63 IN (8, 9) THEN V63=.;        IF V64=9 THEN V64=.;                
   IF V65 IN (0, 999) THEN V65=.;      IF V66 IN (8, 9) THEN V66=.;        
   IF V67 IN (8, 9) THEN V67=.;        IF V68=9 THEN V68=.;                
   IF V69 IN (0, 999) THEN V69=.;      IF V70 IN (8, 9) THEN V70=.;        
   IF V71 IN (8, 9) THEN V71=.;        IF V72=9 THEN V72=.;                
   IF V73=90 THEN V73=.;               IF V74=99 THEN V74=.;               
   IF V75=99 THEN V75=.;               IF V76 IN (7, 9) THEN V76=.;        
   IF V77 IN (0, 999) THEN V77=.;      IF V78 IN (8, 9) THEN V78=.;        
   IF V79 IN (8, 9) THEN V79=.;        IF V80=9 THEN V80=.;                
   IF V81 IN (90, 99) THEN V81=.;      IF V82 IN (98, 99) THEN V82=.;      
   IF V83 IN (98, 99) THEN V83=.;      IF V84 GE 8 OR V84=7 THEN V84=.;    
   IF V85 IN (0, 999) THEN V85=.;      IF V86 IN (8, 9) THEN V86=.;        
   IF V87 IN (8, 9) THEN V87=.;        IF V88=9 THEN V88=.;                
   IF V89 IN (90, 99) THEN V89=.;      IF V90 IN (98, 99) THEN V90=.;      
   IF V91 IN (98, 99) THEN V91=.;      IF V92 GE 8 OR V92=7 THEN V92=.;    
   IF V93 IN (0, 999) THEN V93=.;      IF V94 IN (8, 9) THEN V94=.;        
   IF V95 IN (8, 9) THEN V95=.;        IF V96=9 THEN V96=.;                
   IF V97 IN (90, 99) THEN V97=.;      IF V98 IN (98, 99) THEN V98=.;      
   IF V99 IN (98, 99) THEN V99=.;      IF V100 GE 8 OR V100=7 THEN V100=.; 
   IF V101 IN (0, 999) THEN V101=.;    IF V102 IN (8, 9) THEN V102=.;      
   IF V103 IN (8, 9) THEN V103=.;      IF V104=9 THEN V104=.;              
   IF V105 IN (90, 99) THEN V105=.;    IF V106 IN (98, 99) THEN V106=.;    
   IF V107 IN (98, 99) THEN V107=.;    IF V108 GE 8 OR V108=7 THEN V108=.; 
   IF V109 IN (0, 999) THEN V109=.;    IF V110 IN (8, 9) THEN V110=.;      
   IF V111 IN (8, 9) THEN V111=.;      IF V112=9 THEN V112=.;              
   IF V113 IN (90, 99) THEN V113=.;    IF V114 IN (98, 99) THEN V114=.;    
   IF V115 IN (98, 99) THEN V115=.;    IF V116 GE 8 OR V116=7 THEN V116=.; 
   IF V117 IN (0, 999) THEN V117=.;    IF V118 IN (8, 9) THEN V118=.;      
   IF V119 IN (8, 9) THEN V119=.;      IF V120=9 THEN V120=.;              
   IF V121 IN (90, 99) THEN V121=.;    IF V122 IN (98, 99) THEN V122=.;    
   IF V123 IN (98, 99) THEN V123=.;    IF V124 GE 8 OR V124=7 THEN V124=.; 
   IF V125 IN (0, 999) THEN V125=.;    IF V126 IN (8, 9) THEN V126=.;      
   IF V127 IN (8, 9) THEN V127=.;      IF V128=9 THEN V128=.;              
   IF V129 IN (90, 99) THEN V129=.;    IF V130 IN (98, 99) THEN V130=.;    
   IF V131 IN (98, 99) THEN V131=.;    IF V132 GE 8 OR V132=7 THEN V132=.; 
   IF V133 IN (0, 999) THEN V133=.;    IF V134 IN (8, 9) THEN V134=.;      
   IF V135 IN (8, 9) THEN V135=.;      IF V136=9 THEN V136=.;              
   IF V137 IN (90, 99) THEN V137=.;    IF V138 IN (98, 99) THEN V138=.;    
   IF V139 IN (98, 99) THEN V139=.;    IF V140 GE 8 OR V140=7 THEN V140=.; 
   IF V141 IN (0, 999) THEN V141=.;    IF V142 IN (8, 9) THEN V142=.;      
   IF V143 IN (8, 9) THEN V143=.;      IF V144=9 THEN V144=.;              
   IF V145 IN (90, 99) THEN V145=.;    IF V146 IN (98, 99) THEN V146=.;    
   IF V147 IN (98, 99) THEN V147=.;    IF V148 GE 8 OR V148=7 THEN V148=.; 
   IF V149 IN (0, 999) THEN V149=.;    IF V150 IN (8, 9) THEN V150=.;      
   IF V151 IN (8, 9) THEN V151=.;      IF V152=9 THEN V152=.;              
   IF V153 IN (90, 99) THEN V153=.;    IF V154 IN (98, 99) THEN V154=.;    
   IF V155 IN (98, 99) THEN V155=.;                                        
   IF V156 GE 8 OR V156=7 THEN V156=.;*/                                   
                                                                           
                                                                           
                                                                           
* SAS FORMAT STATEMENT;                                                    
/*                                                                         
FORMAT                                                                     
   V1 V1FT.               V2 V2FT.               V5 V5FT.                  
   V7 V7FT.               V8 V8FT.               V9 V9FT.                  
   V12 V12FT.             V13 V13FT.             V14 V14FT.                
   V17 V17FT.             V19 V19FT.             V20 V20FT.                
   V22 V22FT.             V25 V25FT.             V26 V26FT.                
   V27 V27FT.             V28 V28FT.             V29 V29FT.                
   V30 V30FT.             V31 V31FT.             V32 V32FT.                
   V33 V33FT.             V34 V34FT.             V35 V35FT.                
   V36 V36FT.             V37 V37FT.             V38 V38FT.                
   V39 V39FT.             V40 V40FT.             V41 V41FT.                
   V42 V42FT.             V43 V43FT.             V44 V44FT.                
   V45 V45FT.             V46 V46FT.             V47 V47FT.                
   V48 V48FT.             V49 V49FT.             V50 V50FT.                
   V51 V51FT.             V52 V52FT.             V53 V53FT.                
   V54 V54FT.             V55 V55FT.             V56 V56FT.                
   V57 V57FT.             V58 V58FT.             V59 V59FT.                
   V60 V60FT.             V61 V61FT.             V62 V62FT.                
   V63 V63FT.             V64 V64FT.             V65 V65FT.                
   V66 V66FT.             V67 V67FT.             V68 V68FT.                
   V69 V69FT.             V70 V70FT.             V71 V71FT.                
   V72 V72FT.             V73 V73FT.             V74 V74FT.                
   V75 V75FT.             V76 V76FT.             V77 V77FT.                
   V78 V78FT.             V79 V79FT.             V80 V80FT.                
   V81 V81FT.             V82 V82FT.             V83 V83FT.                
   V84 V84FT.             V85 V85FT.             V86 V86FT.                
   V87 V87FT.             V88 V88FT.             V89 V89FT.                
   V90 V90FT.             V91 V91FT.             V92 V92FT.                
   V93 V93FT.             V94 V94FT.             V95 V95FT.                
   V96 V96FT.             V97 V97FT.             V98 V98FT.                
   V99 V99FT.             V100 V100FT.           V101 V101FT.              
   V102 V102FT.           V103 V103FT.           V104 V104FT.              
   V105 V105FT.           V106 V106FT.           V107 V107FT.              
   V108 V108FT.           V109 V109FT.           V110 V110FT.              
   V111 V111FT.           V112 V112FT.           V113 V113FT.              
   V114 V114FT.           V115 V115FT.           V116 V116FT.              
   V117 V117FT.           V118 V118FT.           V119 V119FT.              
   V120 V120FT.           V121 V121FT.           V122 V122FT.              
   V123 V123FT.           V124 V124FT.           V125 V125FT.              
   V126 V126FT.           V127 V127FT.           V128 V128FT.              
   V129 V129FT.           V130 V130FT.           V131 V131FT.              
   V132 V132FT.           V133 V133FT.           V134 V134FT.              
   V135 V135FT.           V136 V136FT.           V137 V137FT.              
   V138 V138FT.           V139 V139FT.           V140 V140FT.              
   V141 V141FT.           V142 V142FT.           V143 V143FT.              
   V144 V144FT.           V145 V145FT.           V146 V146FT.              
   V147 V147FT.           V148 V148FT.           V149 V149FT.              
   V150 V150FT.           V151 V151FT.           V152 V152FT.              
   V153 V153FT.           V154 V154FT.           V155 V155FT.              
   V156 V156FT.;*/                                                         
