*-------------------------------------------------------------------------*
 |                                                                        |
 |              SPSS DATA DEFINITION STATEMENTS FOR ICPSR 2791            |
 |          CHILDREN'S OUT-OF-COURT STATEMENTS: EFFECTS OF HEARSAY        |
 |       ON JURORS' DECISIONS IN SACRAMENTO COUNTY, CALIFORNIA, AND       |
 |                  MARICOPA COUNTY, ARIZONA, 1994-1997                   |
 |                 (PART 3: HEARSAY STUDY 3 SURVEY DATA)                  |
 |                          FIRST ICPSR VERSION                           |
 |                             NOVEMBER 2002                              |
 |                                                                        |
 | SPSS setup sections are provided for the LRECL version  of  this  data |
 | collection.  These sections are listed below:                          |
 |                                                                        |
 | DATA LIST  assigns the name, type, and decimal specification (if any), |
 | and  specifies  the  beginning  and  ending  column  location for each |
 | variable.  Users must replace the "physical-filename" in the DATA LIST |
 | statement with an appropriate filename for their system.               |
 |                                                                        |
 | VARIABLE LABELS  assigns descriptive labels to all variables. Variable |
 | labels and variable names may be identical for some data files.        |
 |                                                                        |
 | MISSING VALUES declares user-defined missing values. Not all variables |
 | in  this  data set necessarily have user-defined missing values. These |
 | values  can  be treated specially in data transformations, statistical |
 | calculations, and case selection.                                      |
 |                                                                        |
 | VALUE LABELS  assigns  descriptive  labels  to codes found in the data |
 | file.  Not all codes necessarily have assigned value labels.           |
 |                                                                        |
 | PLEASE NOTE:  Users  should  combine  and modify these data definition |
 | statements  to  suit their specific needs.                             |
 |                                                                        |
 | These  data definition  statements were tested using SPSS version 6.13 |
 | for UNIX.                                                              |
 |                                                                        |
*-------------------------------------------------------------------------.
                                                                           
* SPSS DATA LIST FOR 2791,                                                 
* CHILDREN'S OUT-OF-COURT STATEMENTS: EFFECTS OF HEARSAY                   
* ON JURORS' DECISIONS IN SACRAMENTO COUNTY, CALIFORNIA, AND               
* MARICOPA COUNTY, ARIZONA, 1994-1997 .                                    
                                                                           
DATA LIST FILE="physical-filename" /                                       
  TRINUM   1-2            SUBNO    3-5            TODDATYR 6-9             
  DATSTAR  10-15          CONSTATE 16-16          Q1JSEX   17-17           
  Q2JAGE   18-18          Q3JETH   19-19          Q4JEDUC  20-20           
  Q5JSUPDP 21-21          Q6JVIC   22-22          Q7JKIDCT 23-23           
  Q8HOWMK  24-24          Q9KNAM   25-26          Q10KAGET 27-28           
  Q11KAGEA 29-30          Q12KSEX  31-31          Q13KVID  32-32           
  Q14INTK  33-33          Q15IMPVK 34-34          Q16KTES  35-35           
  Q17CUSK  36-36          Q18DNAM  37-38          Q19DRELK 39-39           
  Q20PN1   40-40          Q20TPEV1 41-43          Q20PN2   44-44           
  Q20TPEV2 45-47          Q20PN3   48-48          Q20TPEV3 49-51           
  Q21JVER  52-52          Q22JHUN  53-53          Q23FAIR  54-54           
  Q24FSTK  55-56          Q25WHOM  57-57          Q25WHOF  58-58           
  Q25WHOO  59-59          Q25WHOPO 60-60          Q25WHOSW 61-61           
  Q25WHOD  62-62          Q25WHOFR 63-63          Q25WHOT  64-64           
  Q25WHOOT 65-65          Q26KLIV  66-66          Q27KACC  67-67           
  Q28KPART 68-68          Q29KCID  69-69          Q30KNHAP 70-70           
  Q31KSUG  71-71          Q32KACDE 72-72          Q33KACDA 73-73           
  Q34KCONS 74-74          Q35KCONF 75-75          Q36KHON  76-76           
  Q37KATT  77-77          Q38KSMA  78-78          Q39KEMO  79-79           
  Q39PN1   80-80          Q39WHEM1 81-82          Q39PN2   83-83           
  Q39WHEM2 84-85          Q39PN3   86-86          Q39WHEM3 87-88           
  Q40KFEX  89-89          Q41KGES  90-90          Q42KEYCN 91-91           
  Q43KNERV 92-92          Q44KTLK  93-93          Q45KAGE  94-94           
  Q46KMED  95-95          Q47KBEH  96-96          Q48KSEX  97-97           
  Q49KDEFP 98-98          Q50ADEFP 99-99          Q51KAD   100-100         
  Q52KEXW  101-101        Q53KLIE  102-102        Q54KSUR  103-103         
  Q55KFAN  104-104        Q56KLDIN 105-105        Q57KCCH  106-106         
  Q58KRMB  107-107        Q59KCNST 108-108        Q60KDEFK 109-109         
  Q61KDSAY 110-110        Q61PN1   111-111        Q61DIMP1 112-113         
  Q61PN2   114-114        Q61DIMP2 115-116        Q61PN3   117-117         
  Q61DIMP3 118-119        Q62KGEN  120-120        Q62PN1   121-121         
  Q62KIMP1 122-123        Q62PN2   124-124        Q62KIMP2 125-126         
  Q62PN3   127-127        Q62KIMP3 128-129        Q63KCRE  130-130         
  Q64PN1   131-131        Q64KFAC1 132-134        Q64PN2   135-135         
  Q64KFAC2 136-137        Q64PN3   138-138        Q64KFAC3 139-140         
  Q65KACU  141-141        Q66KTES  142-142        Q67H25   143-143         
  Q68WHOM  144-144        Q68WHOF  145-145        Q68WHOO  146-146         
  Q68WHOPO 147-147        Q68WHOSW 148-148        Q68WHOD  149-149         
  Q68WHOFR 150-150        Q68WHOT  151-151        Q68WHOOT 152-152         
  Q69HMOS  153-154        Q70HRELK 155-156        Q71HCRE  157-157         
  Q72HACU  158-158        Q73HACR  159-159        Q74HACK  160-160         
  Q75HPARK 161-161        Q76HCORK 162-162        Q77HNHPK 163-163         
  Q78HSUGK 164-164        Q79HACC  165-165        Q80HPART 166-166         
  Q81HCID  167-167        Q82HNSAY 168-168        Q83HSUG  169-169         
  Q84HACDE 170-170        Q85HACDA 171-171        Q86HCONS 172-172         
  Q87HCONF 173-173        Q88HHON  174-174        Q89HATT  175-175         
  Q90HSMA  176-176        Q91HSAM  177-177        Q92HEMO  178-178         
  Q93HFEX  179-179        Q94HGES  180-180        Q95HEYCN 181-181         
  Q96HNERV 182-182        Q97HTLK  183-183        Q98HAGE  184-184         
  Q98HYR   185-186        Q99HLIE  187-187        Q100HIMP 188-188         
  Q101HBEL 189-189        Q102HREL 190-191        Q103BAGE 192-192         
  Q104BMED 193-193        Q105BBEH 194-194        Q106BSEX 195-195         
  Q107BDFP 196-196        Q108ADFP 197-197        Q109BAD  198-198         
  Q110BEXW 199-199        Q111BIDA 200-200        Q112BQUE 201-201         
  Q113BMOR 202-202        Q114BVID 203-203        Q115BCON 204-204         
  Q116BLIE 205-205        Q117BSUR 206-206        Q118BFAN 207-207         
  Q119BLED 208-208        Q120BCCH 209-209        Q121BRMB 210-210         
  Q122BDFK 211-211        Q123BSAY 212-212        Q123PN1  213-213         
  Q123BIM1 214-215        Q123PN2  216-216        Q123BIM2 217-218         
  Q123PN3  219-219        Q123BIM3 220-221        Q124BGEN 222-222         
  Q124PN1  223-223        Q124BIM1 224-225        Q124PN2  226-226         
  Q124BIM2 227-228        Q124PN3  229-229        Q124BIM3 230-231         
  Q125BEF  232-232        Q126PN1  233-233        Q126OTH1 234-235         
  Q126PN2  236-236        Q126OTH2 237-238        Q126PN3  239-239         
  Q126OTH3 240-241        KAGE     242-242        VERDICT  243-243         
  DURAT    244-245        DURAT2   246-246 .                               
                                                                           
* SPSS VARIABLE LABELS FOR 2791,                                           
* CHILDREN'S OUT-OF-COURT STATEMENTS: EFFECTS OF HEARSAY                   
* ON JURORS' DECISIONS IN SACRAMENTO COUNTY, CALIFORNIA, AND               
* MARICOPA COUNTY, ARIZONA, 1994-1997 .                                    
                                                                           
VARIABLE LABELS                                                            
  TRINUM    "TRIAL NUMBER"                                                 
  SUBNO     "SUBJECT NUMBER"                                               
  TODDATYR  "TODAYS DATE - YEAR"                                           
  DATSTAR   "DATE TRIAL STARTED"                                           
  CONSTATE  "COUNTY STATE"                                                 
  Q1JSEX    "JUROR GENDER"                                                 
  Q2JAGE    "JUROR AGE"                                                    
  Q3JETH    "JUROR ETHNIC BACKGROUND"                                      
  Q4JEDUC   "JUROR EDUCATION"                                              
  Q5JSUPDP  "JUROR SUPPORT DEATH PENALTY"                                  
  Q6JVIC    "JUROR VICTIM OF CRIME"                                        
  Q7JKIDCT  "AMOUNT OF CONTACT WITH CHILDREN"                              
  Q8HOWMK   "HOW MANY CHILDREN DEF CHARGED W/ABUSING"                      
  Q9KNAM    "MAIN CHILD NAME"                                              
  Q10KAGET  "MAIN CHILD AGE AT TRIAL"                                      
  Q11KAGEA  "MAIN CHILD AGE AT ABUSE"                                      
  Q12KSEX   "MAIN CHILD GENDER"                                            
  Q13KVID   "WAS VIDEOTAPE INTERVIEW SHOWN AT TRIAL"                       
  Q14INTK   "WHO INTERVIEWED CHILD ON VIDEOTAPE"                           
  Q15IMPVK  "HOW IMPORTNT VIDEOTAPE IN BELIEVNG CHILD"                     
  Q16KTES   "HOW MANY CHILDREN TESTIFIED AT TRIAL"                         
  Q17CUSK   "PARENTS DISPUTE CUSTODY OF MAIN CHILD"                        
  Q18DNAM   "DEFENDANT NAME"                                               
  Q19DRELK  "DEFENDANT RELATION TO MAIN CHILD"                             
  Q20PN1    "TOP EVIDENCE POSITIVE NEGATIVE 1"                             
  Q20TPEV1  "MOST IMPORTANT EVIDENCE 1"                                    
  Q20PN2    "TOP EVIDENCE POSITIVE NEGATIVE 2"                             
  Q20TPEV2  "MOST IMPORTANT EVIDENCE 2"                                    
  Q20PN3    "TOP EVIDENCE POSITIVE NEGATIVE 3"                             
  Q20TPEV3  "MOST IMPORTANT EVIDENCE 3"                                    
  Q21JVER   "JURY VERDICT"                                                 
  Q22JHUN   "IF HUNG JUROR VERDICT"                                        
  Q23FAIR   "HOW FAIR TRIAL WAS"                                           
  Q24FSTK   "FIRST PERSON MAIN CHILD TOLD ABOUT ABUSE"                     
  Q25WHOM   "MAIN CHILD TOLD ABOUT ABUSE MOTHER"                           
  Q25WHOF   "MAIN CHILD TOLD ABOUT ABUSE FATHER"                           
  Q25WHOO   "MAIN CHILD TOLD ABOUT ABUSE OTH RELATIVE"                     
  Q25WHOPO  "MAIN CHILD TOLD ABOUT ABUSE COP"                              
  Q25WHOSW  "MAIN CHILD TOLD ABOUT ABUSE SOCIAL WORKR"                     
  Q25WHOD   "MAIN CHILD TOLD ABOUT ABUSE DOCTOR"                           
  Q25WHOFR  "MAIN CHILD TOLD ABOUT ABUSE FRIEND"                           
  Q25WHOT   "MAIN CHILD TOLD ABOUT ABUSE TEACHER"                          
  Q25WHOOT  "MAIN CHILD TOLD ABOUT ABUSE OTHER"                            
  Q26KLIV   "DID MAIN CHILD TESTIFY LIVE IN COURT"                         
  Q27KACC   "KID ACCURATE ABOUT ABUSE"                                     
  Q28KPART  "KID SAY PART OF ABUSE NOT ALL"                                
  Q29KCID   "KID CORRECTLY IDENTIFIED ABUSER"                              
  Q30KNHAP  "KID SAY THINGS NOT HAPPEN"                                    
  Q31KSUG   "KID SUGGESTIBLE IN COURT"                                     
  Q32KACDE  "KID ACCURATE DEFENSE ATTORNEY"                                
  Q33KACDA  "KID ACCURATE PROSECUTOR"                                      
  Q34KCONS  "KID SAY CONSISTENT"                                           
  Q35KCONF  "KID SAY CONFIDENT"                                            
  Q36KHON   "KID SEEM HONEST"                                              
  Q37KATT   "KID SEEM ATTRACTIVE"                                          
  Q38KSMA   "KID SEEM SMART"                                               
  Q39KEMO   "KID SEEM EMOTIONAL"                                           
  Q39PN1    "KID EMOTION POSITIVE NEGATIVE 1"                              
  Q39WHEM1  "WHAT EMOTIONS CHILD HAS 1"                                    
  Q39PN2    "KID EMOTION POSITIVE NEGATIVE 2"                              
  Q39WHEM2  "WHAT EMOTIONS CHILD HAS 2"                                    
  Q39PN3    "KID EMOTION POSITIVE NEGATIVE 3"                              
  Q39WHEM3  "WHAT EMOTIONS CHILD HAS 3"                                    
  Q40KFEX   "KID FACIAL EXPRESSION"                                        
  Q41KGES   "KID GESTURES"                                                 
  Q42KEYCN  "KID EYE CONTACT WITH DEFENDANT"                               
  Q43KNERV  "KID NERVOUSNESS IN COURT"                                     
  Q44KTLK   "WAY KID TALKED IN COURT"                                      
  Q45KAGE   "KID AGE"                                                      
  Q46KMED   "KID MEDICAL EVIDENCE"                                         
  Q47KBEH   "KID BEHAVIOR AFTER ABUSE"                                     
  Q48KSEX   "KID KNOWLEDGE OF SEX"                                         
  Q49KDEFP  "DEFENDANT ABUSED KID IN PAST"                                 
  Q50ADEFP  "DEFENDANT ABUSE ANOTHER KID IN PAST"                          
  Q51KAD    "ADULT SAW KID BEING ABUSED"                                   
  Q52KEXW   "EXPERT WITNESS"                                               
  Q53KLIE   "KID REASON TO LIE"                                            
  Q54KSUR   "KID SURE ABOUT WHAT HAPPENED"                                 
  Q55KFAN   "KID TELL DIFFERNCE BTW REALITY & FANTASY"                     
  Q56KLDIN  "LEADING QUESTIONS IN INTERVIEW"                               
  Q57KCCH   "KID COACHED"                                                  
  Q58KRMB   "KID REMEMBER ABUSE WELL"                                      
  Q59KCNST  "KID CONSISTENT IN TELLING"                                    
  Q60KDEFK  "DEFENDANT KIND OF PERSON TO ABUSE"                            
  Q61KDSAY  "DEFENDANT SAID"                                               
  Q61PN1    "DEF SAY POSITIVE NEGATIVE 1"                                  
  Q61DIMP1  "DEFENDANT IMPORTANT SAY 1"                                    
  Q61PN2    "DEF SAY POSITIVE NEGATIVE 2"                                  
  Q61DIMP2  "DEFENDANT IMPORTANT SAY 2"                                    
  Q61PN3    "DEF SAY POSITIVE NEGATIVE 3"                                  
  Q61DIMP3  "DEFENDANT IMPORTANT SAY 3"                                    
  Q62KGEN   "KID GENDER"                                                   
  Q62PN1    "KID SEX POSITIVE NEGATIVE 1"                                  
  Q62KIMP1  "KID GENDER IMPORTANT 1"                                       
  Q62PN2    "KID SEX POSITIVE NEGATIVE 2"                                  
  Q62KIMP2  "KID GENDER IMPORTANT 2"                                       
  Q62PN3    "KID SEX POSITIVE NEGATIVE 3"                                  
  Q62KIMP3  "KID GENDER IMPORTANT 3"                                       
  Q63KCRE   "KID CREDIBILITY"                                              
  Q64PN1    "BELIEVE KID POSITIVE NEGATIVE 1"                              
  Q64KFAC1  "FACTORS IMPORTANT TO BELIEVE KID 1"                           
  Q64PN2    "BELIEVE KID POSITIVE NEGATIVE 2"                              
  Q64KFAC2  "FACTORS IMPORTANT TO BELIEVE KID 2"                           
  Q64PN3    "BELIEVE KID POSITIVE NEGATIVE 3"                              
  Q64KFAC3  "FACTORS IMPORTANT TO BELIEVE KID 3"                           
  Q65KACU   "KID ACCURACY IN COURT"                                        
  Q66KTES   "IMPORTANCE OF KID TESTIMONY IN COURT"                         
  Q67H25    "RE Q25 HEARSAY WITNESS REPEAT"                                
  Q68WHOM   "WHO CAME TO COURT TO REPEAT MOTHER"                           
  Q68WHOF   "WHO CAME TO COURT TO REPEAT FATHER"                           
  Q68WHOO   "WHO CAME TO COURT TO REPEAT OTH RELATIVE"                     
  Q68WHOPO  "WHO CAME TO COURT TO REPEAT COP"                              
  Q68WHOSW  "WHO CAME TO COURT TO REPEAT SOCIAL WORKR"                     
  Q68WHOD   "WHO CAME TO COURT TO REPEAT DOCTOR"                           
  Q68WHOFR  "WHO CAME TO COURT TO REPEAT FRIEND"                           
  Q68WHOT   "WHO CAME TO COURT TO REPEAT TEACHER"                          
  Q68WHOOT  "WHO CAME TO COURT TO REPEAT OTHER"                            
  Q69HMOS   "ADULT TESTIFY MOST"                                           
  Q70HRELK  "ADULT RELATIONSHIP TO KID"                                    
  Q71HCRE   "ADULT CREDIBILITY"                                            
  Q72HACU   "ADULT RECEIVE ACCURATE FROM KID"                              
  Q73HACR   "ADULT ACCURATE REPEAT IN COURT"                               
  Q74HACK   "KID ACCURATE TO ADULT BEFORE COURT"                           
  Q75HPARK  "KID SAY PART TO ADULT BEFORE COURT"                           
  Q76HCORK  "KID CORRECTLY IDENTIFY DEF BEFORE COURT"                      
  Q77HNHPK  "KID SAY THINGS NOT HAPPEN BEFORE COURT"                       
  Q78HSUGK  "KID SUGGESTIBLE BEFORE COURT"                                 
  Q79HACC   "ADULT ACCURATE ABOUT KID"                                     
  Q80HPART  "ADULT SAY PART OF WHAT KID SAY"                               
  Q81HCID   "ADULT CORRECTLY IDENTIFIED DEFENDANT"                         
  Q82HNSAY  "ADULT SAY THINGS KID NEVER SAY"                               
  Q83HSUG   "ADULT SUGGESTIBLE"                                            
  Q84HACDE  "ADULT ACCURATE DEFENSE ATTORNEY"                              
  Q85HACDA  "ADULT ACCURATE PROSECUTING ATTORNEY"                          
  Q86HCONS  "ADULT CONSISTENT"                                             
  Q87HCONF  "ADULT CONFIDENT"                                              
  Q88HHON   "ADULT HONEST"                                                 
  Q89HATT   "ADULT ATTRACTIVE"                                             
  Q90HSMA   "ADULT SMART"                                                  
  Q91HSAM   "ADULT SAY SAME AS KID IN COURT"                               
  Q92HEMO   "ADULT EMOTION"                                                
  Q93HFEX   "ADULT FACIAL EXPRESSIONS"                                     
  Q94HGES   "ADULT GESTURES"                                               
  Q95HEYCN  "ADULT EYE CONTACT WITH DEFENDANT"                             
  Q96HNERV  "ADULT NERVOUSNESS"                                            
  Q97HTLK   "WAY ADULT TALKED"                                             
  Q98HAGE   "ADULT AGE"                                                    
  Q98HYR    "HOW OLD WAS ADULT"                                            
  Q99HLIE   "ADULT LIE ABOUT WHAT KID SAY"                                 
  Q100HIMP  "IMPORTANCE OF ADULT TESTIMONY"                                
  Q101HBEL  "DID ADULT BELIEVE CHILD"                                      
  Q102HREL  "ADULT RELATIONSHIP TO DEFENDANT"                              
  Q103BAGE  "BOTH CHILDS AGE"                                              
  Q104BMED  "BOTH MEDICAL EVIDENCE"                                        
  Q105BBEH  "BOTH KID BEHAVIOR AFTER ABUSE"                                
  Q106BSEX  "BOTH KID KNOWLEDGE OF SEX"                                    
  Q107BDFP  "BOTH DEFENDANT ABUSED KID IN PAST"                            
  Q108ADFP  "BOTH DEFENDANT ABUSED ANOTHR KID IN PAST"                     
  Q109BAD   "BOTH ADULT SAW ABUSE"                                         
  Q110BEXW  "BOTH EXPERT WITNESS TESTIFIED"                                
  Q111BIDA  "BOTH KID IDEA TO TELL"                                        
  Q112BQUE  "BOTH NATURE OF ADULT QUESTION"                                
  Q113BMOR  "BOTH MORE THAN ONE HEARD KID"                                 
  Q114BVID  "BOTH ADULT QUESTION WAS VIDEOTAPED"                           
  Q115BCON  "BOTH CHILD CONSISTENT"                                        
  Q116BLIE  "BOTH CHILD LIE"                                               
  Q117BSUR  "BOTH CHILD SURE ABOUT WHAT HAPPENED"                          
  Q118BFAN  "BOTH KID DIFFERENCE REALITY FANTASY"                          
  Q119BLED  "BOTH ADULT USE LEADING QUESTION"                              
  Q120BCCH  "BOTH KID COACHED"                                             
  Q121BRMB  "BOTH KID REMEMBER ABUSE"                                      
  Q122BDFK  "BOTH DEFENDANT KIND OF PERSON TO ABUSE"                       
  Q123BSAY  "BOTH DEFENDANT SAY"                                           
  Q123PN1   "BOTH DEF SAY POSITIVE NEGATIVE 1"                             
  Q123BIM1  "BOTH DEFENDANT IMPORTANT SAY 1"                               
  Q123PN2   "BOTH DEF SAY POSITIVE NEGATIVE 2"                             
  Q123BIM2  "BOTH DEFENDANT IMPORTANT SAY 2"                               
  Q123PN3   "BOTH DEF SAY POSITIVE NEGATIVE 3"                             
  Q123BIM3  "BOTH DEFENDANT IMPORTANT SAY 3"                               
  Q124BGEN  "BOTH CHILD GENDER"                                            
  Q124PN1   "BOTH KID SEX POSITIVE NEGATIVE 1"                             
  Q124BIM1  "BOTH CHILD GENDER IMPORTANT 1"                                
  Q124PN2   "BOTH KID SEX POSITIVE NEGATIVE 2"                             
  Q124BIM2  "BOTH CHILD GENDER IMPORTANT 2"                                
  Q124PN3   "BOTH KID SEX POSITIVE NEGATIVE 3"                             
  Q124BIM3  "BOTH CHILD GENDER IMPORTANT 3"                                
  Q125BEF   "IMPORTANCE OF KID SAY BEFORE COURT"                           
  Q126PN1   "OTH FAC BEL KID POSITIVE NEGATIVE 1"                          
  Q126OTH1  "OTHER FACTOR BELIEVE KID 1"                                   
  Q126PN2   "OTH FAC BEL KID POSITIVE NEGATIVE 2"                          
  Q126OTH2  "OTHER FACTOR BELIEVE KID 2"                                   
  Q126PN3   "OTH FAC BEL KID POSITIVE NEGATIVE 3"                          
  Q126OTH3  "OTHER FACTOR BELIEVE KID 3"                                   
  KAGE      "MAIN CHILD AGE AT TRIAL-RECODED"                              
  VERDICT   "JUROR VERDICT-RECODED"                                        
  DURAT     "AGE AT TRIAL - AGE AT ABUSE"                                  
  DURAT2    "DURATION OF ABUSE" .                                          
                                                                           
* SPSS MISSING VALUE COMMAND FOR 2791,                                     
* CHILDREN'S OUT-OF-COURT STATEMENTS: EFFECTS OF HEARSAY                   
* ON JURORS' DECISIONS IN SACRAMENTO COUNTY, CALIFORNIA, AND               
* MARICOPA COUNTY, ARIZONA, 1994-1997 .                                    
                                                                           
*MISSING VALUES                                                            
  TODDATYR (9999)         DATSTAR (888888)        CONSTATE (9)             
  Q3JETH (9)              Q5JSUPDP (9)            Q6JVIC (9)               
  Q7JKIDCT (9)            Q9KNAM (99)             Q10KAGET (99)            
  Q11KAGEA (99)           Q12KSEX (9)             Q13KVID (9)              
  Q14INTK (9)             Q15IMPVK (7, 9)         Q16KTES (9)              
  Q17CUSK (9)             Q18DNAM (99)            Q20PN1 (9)               
  Q20TPEV1 (99)           Q20PN2 (9)              Q20TPEV2 (99)            
  Q20PN3 (9)              Q20TPEV3 (99)           Q21JVER (9)              
  Q22JHUN (9)             Q23FAIR (9)             Q24FSTK (99)             
  Q25WHOM (9)             Q25WHOF (9)             Q25WHOO (9)              
  Q25WHOPO (9)            Q25WHOSW (9)            Q25WHOD (9)              
  Q25WHOFR (9)            Q25WHOT (9)             Q25WHOOT (9)             
  Q26KLIV (9)             Q27KACC (7, 9)          Q28KPART (7, 9)          
  Q29KCID (7, 9)          Q30KNHAP (7, 9)         Q31KSUG (7, 9)           
  Q32KACDE (9)            Q33KACDA (9)            Q34KCONS (9)             
  Q35KCONF (9)            Q36KHON (9)             Q37KATT (9)              
  Q38KSMA (9)             Q39KEMO (7, 9)          Q39PN1 (9)               
  Q39WHEM1 (99)           Q39PN2 (9)              Q39WHEM2 (99)            
  Q39PN3 (9)              Q39WHEM3 (99)           Q40KFEX (7, 9)           
  Q41KGES (7, 9)          Q42KEYCN (7, 9)         Q43KNERV (7, 9)          
  Q44KTLK (7, 9)          Q45KAGE (7, 9)          Q46KMED (7, 9)           
  Q47KBEH (7, 9)          Q48KSEX (7, 9)          Q49KDEFP (7, 9)          
  Q50ADEFP (7, 9)         Q51KAD (7, 9)           Q52KEXW (7, 9)           
  Q53KLIE (7, 9)          Q54KSUR (7, 9)          Q55KFAN (7, 9)           
  Q56KLDIN (7, 9)         Q57KCCH (7, 9)          Q58KRMB (7, 9)           
  Q59KCNST (7, 9)         Q60KDEFK (7, 9)         Q61KDSAY (7, 9)          
  Q61PN1 (9)              Q61DIMP1 (99)           Q61PN2 (9)               
  Q61DIMP2 (99)           Q61PN3 (9)              Q61DIMP3 (99)            
  Q62KGEN (7, 9)          Q62PN1 (9)              Q62KIMP1 (99)            
  Q62PN2 (9)              Q62KIMP2 (99)           Q62PN3 (9)               
  Q62KIMP3 (99)           Q63KCRE (9)             Q64PN1 (9)               
  Q64KFAC1 (99)           Q64PN2 (9)              Q64KFAC2 (99)            
  Q64PN3 (9)              Q64KFAC3 (99)           Q65KACU (9)              
  Q66KTES (9)             Q67H25 (9)              Q68WHOM (9)              
  Q68WHOF (9)             Q68WHOO (9)             Q68WHOPO (9)             
  Q68WHOSW (9)            Q68WHOD (9)             Q68WHOFR (9)             
  Q68WHOT (9)             Q68WHOOT (9)            Q69HMOS (99)             
  Q70HRELK (99)           Q71HCRE (9)             Q72HACU (9)              
  Q73HACR (9)             Q74HACK (7, 9)          Q75HPARK (7, 9)          
  Q76HCORK (7, 9)         Q77HNHPK (7, 9)         Q78HSUGK (7, 9)          
  Q79HACC (7, 9)          Q80HPART (7, 9)         Q81HCID (7, 9)           
  Q82HNSAY (7, 9)         Q83HSUG (7, 9)          Q84HACDE (9)             
  Q85HACDA (9)            Q86HCONS (9)            Q87HCONF (9)             
  Q88HHON (9)             Q89HATT (9)             Q90HSMA (9)              
  Q91HSAM (7, 9)          Q92HEMO (7, 9)          Q93HFEX (7, 9)           
  Q94HGES (7, 9)          Q95HEYCN (7, 9)         Q96HNERV (7, 9)          
  Q97HTLK (7, 9)          Q98HAGE (7, 9)          Q98HYR (99)              
  Q99HLIE (7, 9)          Q100HIMP (9)            Q101HBEL (9)             
  Q102HREL (99)           Q103BAGE (7, 9)         Q104BMED (7, 9)          
  Q105BBEH (7, 9)         Q106BSEX (7, 9)         Q107BDFP (7, 9)          
  Q108ADFP (7, 9)         Q109BAD (7, 9)          Q110BEXW (7, 9)          
  Q111BIDA (7, 9)         Q112BQUE (7, 9)         Q113BMOR (7, 9)          
  Q114BVID (7, 9)         Q115BCON (7, 9)         Q116BLIE (7, 9)          
  Q117BSUR (7, 9)         Q118BFAN (7, 9)         Q119BLED (7, 9)          
  Q120BCCH (7, 9)         Q121BRMB (7, 9)         Q122BDFK (7, 9)          
  Q123BSAY (7, 9)         Q123PN1 (9)             Q123BIM1 (99)            
  Q123PN2 (9)             Q123BIM2 (99)           Q123PN3 (9)              
  Q123BIM3 (99)           Q124BGEN (7, 9)         Q124PN1 (9)              
  Q124BIM1 (99)           Q124PN2 (9)             Q124BIM2 (99)            
  Q124PN3 (9)             Q124BIM3 (99)           Q125BEF (9)              
  Q126PN1 (9)             Q126OTH1 (99)           Q126PN2 (9)              
  Q126OTH2 (99)           Q126PN3 (9)             Q126OTH3 (99)            
  KAGE (9)                VERDICT (9)             DURAT (99)               
  DURAT2 (9) .                                                             
                                                                           
* SPSS VALUE LABELS FOR 2791,                                              
* CHILDREN'S OUT-OF-COURT STATEMENTS: EFFECTS OF HEARSAY                   
* ON JURORS' DECISIONS IN SACRAMENTO COUNTY, CALIFORNIA, AND               
* MARICOPA COUNTY, ARIZONA, 1994-1997 .                                    
                                                                           
VALUE LABELS                                                               
  TODDATYR 9999 "Unknown"                                                  
           /                                                               
  DATSTAR  888888 "Blanked"                                                
           /                                                               
  CONSTATE 1 "Maricopa, AZ"                                                
           2 "Sacramento, CA"                                              
           9 "Unknown"                                                     
           /                                                               
  Q1JSEX   1 "Female"                                                      
           2 "Male"                                                        
           /                                                               
  Q2JAGE   1 "18-30 yrs"                                                   
           2 "31-40 yrs"                                                   
           3 "41-50 yrs"                                                   
           4 "51-60 yrs"                                                   
           5 "61-70 yrs"                                                   
           6 "Over 70"                                                     
           /                                                               
  Q3JETH   1 "African American"                                            
           2 "Asian American"                                              
           3 "Caucasian"                                                   
           4 "Hispanic/Latino"                                             
           5 "Other"                                                       
           9 "Unknown"                                                     
           /                                                               
  Q4JEDUC  1 "H.S. or less / GED"                                          
           2 "College no degree"                                           
           3 "Associate degree"                                            
           4 "Bachelors"                                                   
           5 "Graduate no degree"                                          
           6 "Graduate degree etc"                                         
           7 "Other"                                                       
           /                                                               
  Q5JSUPDP 0 "No"                                                          
           1 "Not sure"                                                    
           2 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q6JVIC   0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q7JKIDCT 1 "Very little contact"                                         
           6 "A lot of contact"                                            
           9 "Unknown"                                                     
           /                                                               
  Q9KNAM   99 "Unknown"                                                    
           /                                                               
  Q10KAGET 99 "Unknown"                                                    
           /                                                               
  Q11KAGEA 99 "Unknown"                                                    
           /                                                               
  Q12KSEX  1 "Female"                                                      
           2 "Male"                                                        
           9 "Unknown"                                                     
           /                                                               
  Q13KVID  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q14INTK  1 "Social worker"                                               
           2 "Physician"                                                   
           3 "Psychologist"                                                
           4 "Police officer"                                              
           5 "Other"                                                       
           9 "Unknown"                                                     
           /                                                               
  Q15IMPVK 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q16KTES  9 "Unknown"                                                     
           /                                                               
  Q17CUSK  0 "No"                                                          
           1 "Dont know"                                                   
           2 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q18DNAM  99 "Unknown"                                                    
           /                                                               
  Q19DRELK 1 "Child parent"                                                
           2 "Child stepparent"                                            
           3 "Boyfriend of child mother"                                   
           4 "Relative"                                                    
           5 "Stranger"                                                    
           6 "Acquaintance"                                                
           7 "Trusted adult"                                               
           8 "Other"                                                       
           /                                                               
  Q20PN1   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q20TPEV1 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions in court"           
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in cout"                  
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person related)"               
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the chilld"                 
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q20PN2   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q20TPEV2 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions in court"           
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q20PN3   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q20TPEV3 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions in court"           
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q21JVER  0 "Not guilty"                                                  
           1 "Guilty of some but not all"                                  
           2 "Guilty"                                                      
           9 "Unknown"                                                     
           /                                                               
  Q22JHUN  0 "Not guilty"                                                  
           1 "Guilty"                                                      
           9 "Unknown"                                                     
           /                                                               
  Q23FAIR  1 "Very unfair"                                                 
           2 "Somewhat unfair"                                             
           3 "Somewhat fair"                                               
           4 "Very fair"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q24FSTK  1 "Mother"                                                      
           2 "Father"                                                      
           3 "Other relative"                                              
           4 "Police officer"                                              
           5 "Social worker"                                               
           6 "Doctor"                                                      
           7 "Friend"                                                      
           8 "Teacher"                                                     
           9 "Other"                                                       
           10 "Spouse"                                                     
           11 "No relationship"                                            
           12 "Ex spouse"                                                  
           13 "Acquaintance"                                               
           99 "Unknown"                                                    
           /                                                               
  Q25WHOM  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q25WHOF  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q25WHOO  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q25WHOPO 0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q25WHOSW 0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q25WHOD  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q25WHOFR 0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q25WHOT  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q25WHOOT 0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q26KLIV  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q27KACC  1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q28KPART 1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q29KCID  1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q30KNHAP 1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q31KSUG  1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q32KACDE 1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q33KACDA 1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q34KCONS 1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q35KCONF 1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q36KHON  1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q37KATT  1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q38KSMA  1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q39KEMO  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q39PN1   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q39WHEM1 1 "Scared or nervous"                                           
           2 "Embarrassment or shame"                                      
           3 "Sad or upset"                                                
           4 "Disgust"                                                     
           5 "Distraught or shaken"                                        
           6 "Anger"                                                       
           7 "Hurt or betrayed"                                            
           8 "Calm"                                                        
           9 "Sincere"                                                     
           10 "Confident"                                                  
           11 "Shy"                                                        
           12 "Quiet"                                                      
           13 "Reluctance to talk"                                         
           14 "Direct"                                                     
           15 "Crying"                                                     
           16 "Facial expressions"                                         
           17 "Body gestures"                                              
           18 "Actions related to testifying"                              
           19 "Eye contact"                                                
           20 "Lack of animosity"                                          
           21 "Lack of fear"                                               
           22 "Lack of confidence"                                         
           23 "Other"                                                      
           24 "No or little emotions"                                      
           25 "Felt responsible"                                           
           26 "Fear or dislike of the defendant"                           
           88 "Unscorable or ambiguous"                                    
           99 "Missing"                                                    
           /                                                               
  Q39PN2   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q39WHEM2 1 "Scared or nervous"                                           
           2 "Embarrassment or shame"                                      
           3 "Sad or upset"                                                
           4 "Disgust"                                                     
           5 "Distraught or shaken"                                        
           6 "Anger"                                                       
           7 "Hurt or betrayed"                                            
           8 "Calm"                                                        
           9 "Sincere"                                                     
           10 "Confident"                                                  
           11 "Shy"                                                        
           12 "Quiet"                                                      
           13 "Reluctance to talk"                                         
           14 "Direct"                                                     
           15 "Crying"                                                     
           16 "Facial expressions"                                         
           17 "Body gestures"                                              
           18 "Actions related to testifying"                              
           19 "Eye contact"                                                
           20 "Lack of animosity"                                          
           21 "Lack of fear"                                               
           22 "Lack of confidence"                                         
           23 "Other"                                                      
           24 "No or little emotions"                                      
           25 "Felt responsible"                                           
           26 "Fear or dislike of the defendant"                           
           88 "Unscorable or ambiguous"                                    
           99 "Missing"                                                    
           /                                                               
  Q39PN3   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q39WHEM3 1 "Scared or nervous"                                           
           2 "Embarrassment or shame"                                      
           3 "Sad or upset"                                                
           4 "Disgust"                                                     
           5 "Distraught or shaken"                                        
           6 "Anger"                                                       
           7 "Hurt or betrayed"                                            
           8 "Calm"                                                        
           9 "Sincere"                                                     
           10 "Confident"                                                  
           11 "Shy"                                                        
           12 "Quiet"                                                      
           13 "Reluctance to talk"                                         
           14 "Direct"                                                     
           15 "Crying"                                                     
           16 "Facial expressions"                                         
           17 "Body gestures"                                              
           18 "Actions related to testifying"                              
           19 "Eye contact"                                                
           20 "Lack of animosity"                                          
           21 "Lack of fear"                                               
           22 "Lack of confidence"                                         
           23 "Other"                                                      
           24 "No or little emotions"                                      
           25 "Felt responsible"                                           
           26 "Fear or dislike of the defendant"                           
           88 "Unscorable or ambiguous"                                    
           99 "Missing"                                                    
           /                                                               
  Q40KFEX  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q41KGES  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q42KEYCN 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q43KNERV 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q44KTLK  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q45KAGE  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q46KMED  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q47KBEH  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q48KSEX  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q49KDEFP 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q50ADEFP 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q51KAD   1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q52KEXW  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q53KLIE  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q54KSUR  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q55KFAN  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q56KLDIN 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q57KCCH  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q58KRMB  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q59KCNST 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q60KDEFK 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q61KDSAY 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q61PN1   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q61DIMP1 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions in court"           
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q61PN2   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q61DIMP2 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q61PN3   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q61DIMP3 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q62KGEN  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q62PN1   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q62KIMP1 1 "Confusion of female-male relationships"                      
           2 "Child age (in relation to gender)"                           
           3 "One gender more likely to lie than another"                  
           4 "One gender-more intelligent than the other"                  
           5 "Stereotypes of the genders"                                  
           6 "Child was same gender as other alleged victims"              
           7 "Females are sexually abused more often than males"           
           8 "Other"                                                       
           9 "Not important"                                               
           10 "Juror or juror's child is same gender as child victim"      
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           /                                                               
  Q62PN2   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q62KIMP2 1 "Confusion of female-male relationships"                      
           2 "Child age (in relation to gender)"                           
           3 "One gender more likely to lie than another"                  
           4 "One gender-more intelligent than the other"                  
           5 "Stereotypes of the genders"                                  
           6 "Child was same gender as other alleged victims"              
           7 "Females are sexually abused more often than males"           
           8 "Other"                                                       
           9 "Not important"                                               
           10 "Juror or juror's child is same gender as child victim"      
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           /                                                               
  Q62PN3   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q62KIMP3 1 "Confusion of female-male relationships"                      
           2 "Child age (in relation to gender)"                           
           3 "One gender more likely to lie than another"                  
           4 "One gender-more intelligent than the other"                  
           5 "Stereotypes of the genders"                                  
           6 "Child was same gender as other alleged victims"              
           7 "Females are sexually abused more often than males"           
           8 "Other"                                                       
           9 "Not important"                                               
           10 "Juror or juror's child is same gender as child victim"      
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           /                                                               
  Q63KCRE  0 "Not credible"                                                
           1 "Somewhat credible"                                           
           2 "Very credible"                                               
           9 "Unknown"                                                     
           /                                                               
  Q64PN1   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q64KFAC1 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q64PN2   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q64KFAC2 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q64PN3   0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q64KFAC3 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q65KACU  0 "Not accurate"                                                
           1 "Partly accurate"                                             
           2 "Mostly accurate"                                             
           9 "Unknown"                                                     
           /                                                               
  Q66KTES  1 "Not imp for vote"                                            
           2 "Slight imp for vote"                                         
           3 "Mod imp for vote"                                            
           4 "Ext imp for vote"                                            
           9 "Unknown"                                                     
           /                                                               
  Q67H25   0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q68WHOM  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q68WHOF  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q68WHOO  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q68WHOPO 0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q68WHOSW 0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q68WHOD  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q68WHOFR 0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q68WHOT  0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q68WHOOT 0 "No"                                                          
           1 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q69HMOS  1 "Mother"                                                      
           2 "Father"                                                      
           3 "Other relative"                                              
           4 "Police officer"                                              
           5 "Social worker"                                               
           6 "Doctor"                                                      
           7 "Friend"                                                      
           8 "Teacher"                                                     
           9 "Other"                                                       
           10 "Spouse"                                                     
           11 "No relationship"                                            
           12 "Ex spouse"                                                  
           13 "Acquaintance"                                               
           99 "Unknown"                                                    
           /                                                               
  Q70HRELK 1 "Mother"                                                      
           2 "Father"                                                      
           3 "Other relative"                                              
           4 "Police officer"                                              
           5 "Social worker"                                               
           6 "Doctor"                                                      
           7 "Friend"                                                      
           8 "Teacher"                                                     
           9 "Other"                                                       
           10 "Spouse"                                                     
           11 "No relationship"                                            
           12 "Ex spouse"                                                  
           13 "Acquaintance"                                               
           99 "Unknown"                                                    
           /                                                               
  Q71HCRE  0 "Not credible"                                                
           1 "Somewhat credible"                                           
           2 "Very credible"                                               
           9 "Unknown"                                                     
           /                                                               
  Q72HACU  0 "Not accurate"                                                
           1 "Partly accurate"                                             
           2 "Mostly accurate"                                             
           9 "Unknown"                                                     
           /                                                               
  Q73HACR  0 "Not accurate"                                                
           1 "Partly accurate"                                             
           2 "Mostly accurate"                                             
           9 "Unknown"                                                     
           /                                                               
  Q74HACK  1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q75HPARK 1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q76HCORK 1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q77HNHPK 1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q78HSUGK 1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q79HACC  1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q80HPART 1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q81HCID  1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q82HNSAY 1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q83HSUG  1 "Ext unlikely"                                                
           2 "Mod unlikely"                                                
           3 "Sli unlikely"                                                
           4 "Sli likely"                                                  
           5 "Mod likely"                                                  
           6 "Ext likely"                                                  
           7 "Not applicable"                                              
           9 "Unknown"                                                     
           /                                                               
  Q84HACDE 1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q85HACDA 1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q86HCONS 1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q87HCONF 1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q88HHON  1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q89HATT  1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q90HSMA  1 "Not at all"                                                  
           2 "Somewhat"                                                    
           3 "Moderately"                                                  
           4 "Extremely"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q91HSAM  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q92HEMO  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q93HFEX  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q94HGES  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q95HEYCN 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q96HNERV 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q97HTLK  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q98HAGE  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q98HYR   99 "Unknown"                                                    
           /                                                               
  Q99HLIE  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q100HIMP 1 "Not imp for vote"                                            
           2 "Slight imp for vote"                                         
           3 "Mod imp for vote"                                            
           4 "Ext imp for vote"                                            
           9 "Unknown"                                                     
           /                                                               
  Q101HBEL 0 "No"                                                          
           1 "Dont know"                                                   
           2 "Yes"                                                         
           9 "Unknown"                                                     
           /                                                               
  Q102HREL 1 "Mother"                                                      
           2 "Father"                                                      
           3 "Other relative"                                              
           4 "Police officer"                                              
           5 "Social worker"                                               
           6 "Doctor"                                                      
           7 "Friend"                                                      
           8 "Teacher"                                                     
           9 "Other"                                                       
           10 "Spouse"                                                     
           11 "No relationship"                                            
           12 "Ex spouse"                                                  
           13 "Acquaintance"                                               
           99 "Unknown"                                                    
           /                                                               
  Q103BAGE 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q104BMED 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q105BBEH 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q106BSEX 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q107BDFP 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q108ADFP 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q109BAD  1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q110BEXW 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q111BIDA 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q112BQUE 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q113BMOR 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q114BVID 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q115BCON 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q116BLIE 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q117BSUR 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q118BFAN 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q119BLED 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q120BCCH 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q121BRMB 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q122BDFK 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q123BSAY 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q123PN1  0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q123BIM1 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More Qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q123PN2  0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q123BIM2 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q123PN3  0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q123BIM3 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q124BGEN 1 "Extreme impt believ"                                         
           2 "Moderate impt believ"                                        
           3 "Slight impt believ"                                          
           4 "Slight impt n believ"                                        
           5 "Moderate impt n believ"                                      
           6 "Extreme impt n believ"                                       
           7 "Not apply"                                                   
           9 "Unknown"                                                     
           /                                                               
  Q124PN1  0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q124BIM1 1 "Confusion of female-male relationships"                      
           2 "Child age (in relation to gender)"                           
           3 "One gender more likely to lie than another"                  
           4 "One gender-more intelligent than the other"                  
           5 "Stereotypes of the genders"                                  
           6 "Child was same gender as other alleged victims"              
           7 "Females are sexually abused more often than males"           
           8 "Other"                                                       
           9 "Not important"                                               
           10 "Juror or juror's child is same gender as child victim"      
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           /                                                               
  Q124PN2  0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q124BIM2 1 "Confusion of female-male relationships"                      
           2 "Child age (in relation to gender)"                           
           3 "One gender more likely to lie than another"                  
           4 "One gender-more intelligent than the other"                  
           5 "Stereotypes of the genders"                                  
           6 "Child was same gender as other alleged victims"              
           7 "Females are sexually abused more often than males"           
           8 "Other"                                                       
           9 "Not important"                                               
           10 "Juror or juror's child is same gender as child victim"      
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           /                                                               
  Q124PN3  0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q124BIM3 1 "Confusion of female-male relationships"                      
           2 "Child age (in relation to gender)"                           
           3 "One gender more likely to lie than another"                  
           4 "One gender-more intelligent than the other"                  
           5 "Stereotypes of the genders"                                  
           6 "Child was same gender as other alleged victims"              
           7 "Females are sexually abused more often than males"           
           8 "Other"                                                       
           9 "Not important"                                               
           10 "Juror or juror's child is same gender as child victim"      
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           /                                                               
  Q125BEF  1 "Not imp for vote"                                            
           2 "Slight imp for vote"                                         
           3 "Mod imp for vote"                                            
           4 "Ext imp for vote"                                            
           9 "Unknown"                                                     
           /                                                               
  Q126PN1  0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q126OTH1 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q126PN2  0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q126OTH2 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  Q126PN3  0 "Negative not believed"                                       
           1 "Positive believed"                                           
           9 "Unknown"                                                     
           /                                                               
  Q126OTH3 1 "The child honesty"                                           
           2 "The child overall credibility"                               
           3 "The child had no motive to lie"                              
           4 "Before trial-child emotions/actions/demeanor"                
           5 "During trial-child emotions/actions/demeanor"                
           6 "The child body or facial expressions during trial"           
           7 "The child personal features"                                 
           8 "The child feelings toward defendant"                         
           9 "The child knowledge understanding of situation"              
           10 "The child inappropriate sexual knowledge/behavior"          
           11 "The child suggestibility/coached"                           
           12 "The child testimony"                                        
           13 "The child consistent with sexual abuse"                     
           14 "The child-consistent with other victims"                    
           15 "Child-consistent with corrob evidence"                      
           16 "The child memory ability"                                   
           17 "Child-consistency in statement"                             
           18 "The child confidence in statement"                          
           19 "The child (general)"                                        
           20 "Factors related to the child disclosure"                    
           21 "More Qs of child during trial"                              
           22 "The use of suggestive qs by attorneys"                      
           23 "The defendant honesty"                                      
           24 "The defendant testimony/way of testifying"                  
           25 "Defendant confession"                                       
           26 "The defendant denial"                                       
           27 "The defendant emotions/demeanor/actions"                    
           28 "The defendant alleged actions before the trial"             
           29 "The defendant personal features"                            
           30 "Evidence for or against the defendant"                      
           31 "The defendant/wrong defendant"                              
           32 "More Qs of the def during the trial"                        
           33 "The defendant did not testify"                              
           34 "Officer-honesty"                                            
           35 "Officer-memory ability"                                     
           36 "Officer-emotions/actions/demeanor in court"                 
           37 "Officer-feelings towards child or def"                      
           38 "Officer-overall intelligence"                               
           39 "Officer-own suggestibility"                                 
           40 "Officer-testimony (accuracy)"                               
           41 "Officer-consistency in statement"                           
           42 "Officer-confidence in statement"                            
           43 "Officer-professionalism"                                    
           44 "Officer-personal features"                                  
           45 "Police officer (general)"                                   
           46 "More Qs of the police officer during trial"                 
           47 "The doctor honesty"                                         
           48 "The doctor testimony"                                       
           49 "The doctor professionalism actions"                         
           50 "The doctor expert experience"                               
           51 "The doctor personal features"                               
           52 "The doctor feelings towards child or def"                   
           53 "The doctor emotions/actions in court"                       
           54 "The doctor overall intelligence"                            
           55 "The doctor own suggestibility"                              
           56 "The med doctor (general)"                                   
           57 "The mother honesty"                                         
           58 "The mother testimony"                                       
           59 "The mother feelings towards child or def"                   
           60 "Before trial-mother emotions/actions"                       
           61 "In court-mother emotions/actions"                           
           62 "The mother personal features"                               
           63 "The mother (general)"                                       
           64 "The interview/videotape (general)"                          
           65 "Way the child was interviewed"                              
           66 "Use of suggestive qs during interview"                      
           67 "Use of anatomical dolls in interview"                       
           68 "Interviewer-experience in interviewing"                     
           69 "Interviewer-personal features"                              
           70 "The interviewers feelings towards child or def"             
           71 "Interviewer (general)"                                      
           72 "Present a videotape/more info on interview"                 
           73 "More qs of the child during interview"                      
           74 "Medical evidence"                                           
           75 "Physical evidence"                                          
           76 "Not enough evidence"                                        
           77 "Case details - better evidence/testimony"                   
           78 "People in case - better evidence/testimony"                 
           79 "Have expert witness"                                        
           80 "Background/case details"                                    
           81 "General attitudes towards children"                         
           82 "Reasonable doubt"                                           
           83 "No witness to the abuse"                                    
           84 "Def atty's performance/improve def strategy"                
           85 "DAs atty's performance/improve prosecution strategy"        
           86 "Other imaginative explanation of juror"                     
           87 "None/nothing/not considered (person relative)"              
           88 "Needed tape/transcript of interview to access accuracy"     
           89 "Based on evidence presented/circumstantial"                 
           91 "Defendant consistency in statement"                         
           92 "Defendant confidence in statement"                          
           93 "The defendant pushed blame onto the child"                  
           94 "The def was (in)consistent with other witnesses"            
           95 "No other evidence besides child's word"                     
           96 "The defendant modus operandi"                               
           98 "Ambiguous or unscorable"                                    
           99 "Missing"                                                    
           100 "The psych honesty"                                         
           101 "The psych testimony"                                       
           102 "The psych professionalism actions"                         
           103 "The psych expert experience"                               
           104 "The psych personal features"                               
           105 "The psych feelings towards child defendant"                
           106 "The psych emotions actions in court"                       
           107 "The psych overall intelligence"                            
           108 "The psych own suggestibility"                              
           109 "The psych doctor (general)"                                
           /                                                               
  KAGE     1 "12 or younger at time of trial"                              
           2 "13 or older at time of trial"                                
           9 "Unknown"                                                     
           /                                                               
  VERDICT  0 "Not guilty"                                                  
           1 "Guilty"                                                      
           9 "Unknown"                                                     
           /                                                               
  DURAT    -2 "Undoc code"                                                 
           99 "Unknown"                                                    
           /                                                               
  DURAT2   1 "2 years or less"                                             
           2 "3 years or more"                                             
           9 "Unknown" .                                                   
