% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{arrow_head_hypotrochoid}
\alias{arrow_head_hypotrochoid}
\alias{arrow_head_deltoid}
\title{Make spirograph arrowheads}
\usage{
arrow_head_hypotrochoid(
  r = 4,
  R = 3,
  d = r,
  windings = r,
  rotate = 0,
  rescale = c(1, 1),
  nudge = c(0, 0),
  transformations = c("unitizer", "rotater", "rescaler", "nudger"),
  n = 361,
  plot = FALSE
)

arrow_head_deltoid(
  d = 2.6,
  rotate = pi,
  rescale = c(1, 0.5),
  nudge = c(0, 0),
  transformations = c("unitizer", "rotater", "rescaler", "nudger"),
  n = 361,
  plot = FALSE
)
}
\arguments{
\item{r}{cycling circle radius}

\item{R}{fixed circle radius}

\item{d}{pen distance}

\item{windings}{windings}

\item{rotate}{rotation angle in radians}

\item{rescale}{a single value or 2-length vector for scaling in x and y}

\item{nudge}{a single value or 2-length vector for nudging in x and y}

\item{transformations}{a vector of transformation functions}

\item{n}{number of points in polygon}

\item{plot}{plot arrowhead if TRUE}
}
\value{
a matrix
}
\description{
Make spirograph arrowheads
}
\examples{
star5 <- arrow_head_hypotrochoid(plot = TRUE, rotate = pi)
star5_long <- arrow_head_hypotrochoid(
   plot = TRUE,
   r = 4,
   R = 3,
   rotate = pi,
   rescale = c(1, .4)
   )
deltoid_long <- arrow_head_deltoid(plot = TRUE, rescale = c(1,1))
deltoid_long <- arrow_head_deltoid(plot = TRUE)
deltoid_spaced <- arrow_head_deltoid(plot = TRUE,
                                    rescale = c(.6,.3),
                                    nudge = c(.4, 0))
}
