% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{arrow_head_catenary}
\alias{arrow_head_catenary}
\title{Make catenary arrowhead}
\usage{
arrow_head_catenary(
  a = 1,
  base_width = 0,
  thickness = 1.2,
  closed = FALSE,
  rotate = 0,
  rescale = c(1, 1),
  nudge = c(0, 0),
  transformations = c("rotater", "rescaler", "nudger"),
  n = 361,
  plot = FALSE
)
}
\arguments{
\item{a}{peakedness of the arch (near 0 is more flat, large like parabola)}

\item{base_width}{width of the base of the arch}

\item{thickness}{thickness of the top of the arch}

\item{closed}{if TRUE, closed arch}

\item{rotate}{rotation angle in radians}

\item{rescale}{a single value or 2-length vector for scaling in x and y}

\item{nudge}{a single value or 2-length vector for nudging in x and y}

\item{transformations}{a vector of transformation functions}

\item{n}{number of points in polygon}

\item{plot}{plot arrowhead if TRUE}
}
\value{
a matrix
}
\description{
Make catenary arrowhead
}
\examples{
catenary <- arrow_head_catenary(plot = TRUE)
stlouis <-
  arrow_head_catenary(
    plot = TRUE,
    a = 0.4,
    base_width = 0.2,
    thickness = .09
  )

bluntnosed_catenary <-
  arrow_head_catenary(
    plot = TRUE,
    a = .2,
    thickness = 1.2
  )
}
