% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\name{permutations}
\alias{permutations}
\title{Permutations generator}
\usage{
permutations(x = NULL, k = NULL, n = NULL, v = NULL, freq = NULL,
  replace = FALSE, layout = NULL, nitem = -1L, skip = NULL,
  index = NULL, nsample = NULL, drop = NULL)
}
\arguments{
\item{x}{an integer or a vector, will be treated as \code{n} if integer; otherwise, will be treated as \code{v}.
Should not be specified together with \code{n} and \code{v}.}

\item{k}{an integer, the number of items drawn, defaults to \code{n} if \code{freq} is \code{NULL} else \code{sum(freq)}}

\item{n}{an integer, the total number of items, its value may be implicitly deduced from \code{length(v)} or \code{length(freq)}}

\item{v}{a vector to be drawn, defaults to \code{1:n}.}

\item{freq}{an integer vector of item repeat frequencies}

\item{replace}{an logical to draw items with replacement}

\item{layout}{if "row", "column" or "list" is specified, the returned value would be a
"row-major" matrix, a "column-major" matrix or a list respectively}

\item{nitem}{number of permutations required, usually used with \code{skip}}

\item{skip}{the number of permutations skipped}

\item{index}{a vector of indices of the desired permutations}

\item{nsample}{sampling random permutations}

\item{drop}{vectorize a matrix or unlist a list}
}
\description{
This function generates all the permutations of selecting \code{k} items from \code{n} items.
The results are in lexicographical order.
}
\examples{
permutations(3)
permutations(LETTERS[1:3])

# choose 2 from 4
permutations(4, 2)
permutations(LETTERS[1:3], k = 2)

# multiset with frequencies c(2, 3)
permutations(k = 3, freq = c(2, 3))

# with replacement
permutations(4, 2, replace = TRUE)

# column major
permutations(3, layout = "column")
permutations(4, 2, layout = "column")

# list output
permutations(3, layout = "list")
permutations(4, 2, layout = "list")

# specifc range of permutations
permutations(4, 2, nitem = 2, skip = 3)

# specific permutations
permutations(4, 2, index = c(3, 5))

# random permutations
permutations(4, 2, nsample = 3)

# zero sized permutations
dim(permutations(0))
dim(permutations(5, 0))
dim(permutations(5, 6))
dim(permutations(0, 0))
dim(permutations(0, 1))

}
\seealso{
\link{ipermutations} for iterating permutations and \link{npermutations} to calculate number of permutations
}
