% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{predicate-numeric}
\alias{predicate-numeric}
\alias{is_zero}
\alias{is_odd}
\alias{is_even}
\alias{is_positive}
\alias{is_negative}
\alias{is_whole}
\title{Numeric Predicates}
\usage{
is_zero(x, tolerance = sqrt(.Machine$double.eps), ...)

is_odd(x, ...)

is_even(x, ...)

is_positive(x, strict = FALSE, ...)

is_negative(x, strict = FALSE, ...)

is_whole(x, tolerance = sqrt(.Machine$double.eps), ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} object to be tested.}

\item{tolerance}{A \code{\link{numeric}} scalar giving the tolerance to check within.}

\item{...}{Currently not used.}

\item{strict}{A \code{\link{logical}} scalar: should strict inequality be used?}
}
\value{
A \code{\link{logical}} vector.
}
\description{
Check numeric objects:
\itemize{
\item \code{is_zero()} checks if an object contains only zeros.
\item \code{is_odd()} and \code{is_even()} check if a number is odd or even, respectively.
\item \code{is_positive()} and \code{is_negative} check if an object contains only
(strictly) positive or negative numbers.
\item \code{is_whole()} checks if an object only contains whole numbers.
}
}
\seealso{
Other predicates: 
\code{\link{is_scalar}},
\code{\link{predicate-matrix}},
\code{\link{predicate-trend}},
\code{\link{predicate-type}},
\code{\link{predicate-utils}}
}
\concept{predicates}
