% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitTags.R
\name{splitTagsLocal}
\alias{splitTagsLocal}
\alias{splitTagsRemote}
\title{Split Tags in Repository}
\usage{
splitTagsLocal(repoDir = aoptions("repoDir"))

splitTagsRemote(repo = aoptions("repo"), user = aoptions("user"),
  branch = aoptions("branch"), subdir = aoptions("subdir"),
  repoType = aoptions("repoType"))
}
\arguments{
\item{repoDir}{While working with the local repository. A character denoting 
an existing directory of the Repository.}

\item{repo}{While working with the Github repository. A character containing
a name of the Github repository on which the Repository is stored.
By default set to \code{NULL} - see \code{Note}.}

\item{user}{While working with the Github repository. A character containing
a name of the Github user on whose account the \code{repo} is created.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{While working with the Github repository. A character containing
a name of the Github Repository's branch on which the Repository is stored.
Default \code{branch} is \code{master}.}

\item{subdir}{While working with the Github repository. A character containing
a name of a directory on the Github repository on which the Repository is stored.
If the Repository is stored in the main folder of the Github repository,
this should be set to \code{subdir = "/"} as default.}

\item{repoType}{A character containing a type of the remote repository. 
Currently it can be 'github' or 'bitbucket'.}
}
\value{
A \code{data.frame} with 4 columns: \code{artifact}, \code{tagKey},
\code{tagValue} and \code{createdDate}, corresponding to the current state of \link{Repository}.
}
\description{
\code{splitTagsLocal} and \code{splitTagsRemote} functions split \code{tag} column from
\emph{tag} table placed in \code{backpack.db} into two separate columns:
\code{tagKey} and \code{tagValue}.
}
\details{
\code{tag} column from \emph{tag} table has normally the follwing structure:
\code{TagKey:TagValue}. \code{splitTagsLocal} and \code{splitTagsRemote} functions
can be used to split \code{tag} column into two separate columns:
\code{tagKey} and \code{tagValue}. As a result functions from \code{dplyr} package
can be used to easily summarize, search, and extract artifacts' Tags.
See \code{examples}.
}
\note{
If \code{repo} and \code{user} are set to \code{NULL} (as default) in the Github mode
then global parameters set in \link{setRemoteRepo} function are used.

Sometimes we can use \code{addTags*} function or \code{userTags} parameter
in \code{saveToRepo} to specify a \code{Tag} which might not match
\code{TagKey:TagValue} structure. It is simply \code{Tag}. In this case 
\code{tagKey = userTags} and \code{tagValue = Tag}. See \code{examples}.

To learn more about \code{Tags} and \code{Repository} structure check 
\link{Tags} and \link{Repository}.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
\dontrun{
## LOCAL VERSION 

setLocalRepo(system.file("graphGallery", package = "archivist"))
head(showLocalRepo(method = "tags"))
head(splitTagsLocal() )

## Github Version
# Let's check how does table tag look like while we are using the
# Gitub repository.
# We will choose only special columns of data frames that show Tags
head(showRemoteRepo( user = "pbiecek", repo = "archivist", method = "tags" )[,2])
head(splitTagsRemote( user = "pbiecek", repo = "archivist" )[,2:3])

head(splitTagsRemote("PieczaraPietraszki", "BetaAndBit", "master", "UniwersytetDzieci/arepo"))
}
}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}
\author{
Witold Chodor , \email{witoldchodor@gmail.com}
}
\concept{archivist}
