% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilColorIndices.R
\name{horizonColorIndices}
\alias{horizonColorIndices}
\title{Horizon Color Indices}
\usage{
horizonColorIndices(p, hue = "m_hue", value = "m_value", chroma = "m_chroma")
}
\arguments{
\item{p}{A SoilProfileCollection}

\item{hue}{Column name containing moist hue; default: "m_hue"}

\item{value}{Column name containing moist value; default: "m_value"}

\item{chroma}{Column name containing moist chroma; default: "m_chroma"}
}
\value{
A data.frame containing unique pedon and horizon IDs and horizon-level color indices.
}
\description{
Calculate basic horizon-level color indices for a SoilProfileCollection. Basic indices do not require aggregation over the whole profile or comparison to a "reference" (e.g. parent material) color. Includes Hurst (1977) Redness Index, Barron-Torrent Redness Index (1986) and Buntley-Westin Index (1965). This is a wrapper method around several horizon-level indices. See the individual functions for more details.
}
\examples{
data(sp1)

# promote sp1 data to SoilProfileCollection
depths(sp1) <- id ~ top + bottom

# move site data
site(sp1) <- ~ group

# compute indices
# merged into `sp1` with left-join on hzidname(sp1)
horizons(sp1) <- horizonColorIndices(sp1, hue="hue", value="value", chroma="chroma")

# visualize
par(mar=c(0, 1, 3, 1))
plot(sp1, color='hurst_redness')
plot(sp1, color='barron_torrent_redness')
plot(sp1, color='buntley_westin')
}
\seealso{
\code{\link{hurst.redness}} \code{\link{barron.torrent.redness.LAB}} \code{\link{buntley.westin.index}}
}
\author{
Andrew G. Brown.
}
