% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_estimateHB.R
\name{apollo_estimateHB}
\alias{apollo_estimateHB}
\title{Estimates model using Bayesian estimation}
\usage{
apollo_estimateHB(
  apollo_beta,
  apollo_fixed,
  apollo_probabilities,
  apollo_inputs,
  estimate_settings = NA
)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not change during estimation.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters.
  \item \strong{\code{apollo_inputs}}: List containing options of the model. See \link{apollo_validateInputs}.
  \item \strong{\code{functionality}}: Character. Can be either \strong{\code{"components"}}, \strong{\code{"conditionals"}}, \strong{\code{"estimate"}} (default), \strong{\code{"gradient"}}, \strong{\code{"output"}}, \strong{\code{"prediction"}}, \strong{\code{"preprocess"}}, \strong{\code{"raw"}}, \strong{\code{"report"}}, \strong{\code{"shares_LL"}}, \strong{\code{"validate"}} or \strong{\code{"zero_LL"}}.
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{estimate_settings}{List. Options controlling the estimation process, as used for in \link{apollo_estimate}.}
}
\value{
model object
}
\description{
Estimates a model using Bayesian estimation on the likelihood function defined by \code{apollo_probabilities}.
}
\details{
This is a sub function of \link{apollo_estimate} which is called when using Bayesian estimation.
}
