% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis.R
\name{xlim2}
\alias{xlim2}
\alias{ylim2}
\title{xlim2}
\usage{
xlim2(gg, limits = NULL)

ylim2(gg, limits = NULL)
}
\arguments{
\item{gg}{ggplot object}

\item{limits}{vector of limits. If NULL, determine from `gg`.}
}
\value{
ggplot2 object with new limits
}
\description{
set axis limits (x or y) of a `ggplot` object (left hand side of `+`)
based on the x (`xlim2`) or y (`ylim2`) limits of another `ggplot` object (right hand side of `+`).
This is useful for using `cowplot` or `patchwork` to align `ggplot` objects.
}
\examples{
library(ggplot2)
library(aplot)
p1 <- ggplot(mtcars, aes(cyl)) + geom_bar()
p2 <- ggplot(subset(mtcars, cyl != 4), aes(cyl)) + geom_bar()
p2 + xlim2(p1)
}
\author{
Guangchuang Yu
}
