% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getTree.R
\name{getTree}
\alias{getTree}
\title{Build phylogenies from multiple gene data}
\usage{
getTree(x, pool = FALSE, genes = TRUE, model = "N",
  pairwise.deletion = TRUE, method = nj, ladderize = TRUE,
  negative.branch.length = FALSE, ...)
}
\arguments{
\item{x}{a \linkS4class{multidna} object.}

\item{pool}{a logical indicating if all genes should be pooled (concatenated) to obtain a single tree; defaults to FALSE.}

\item{genes}{an optional vector indicating the genes to retain for the concatenation; any way to subset the list in x@dna is acceptable; by default, all genes are used.}

\item{model}{a character string passed to \code{\link[ape]{dist.dna}} describing the model to be used to compute genetic distances; defaults to 'N', the absolute number of mutations separating sequences.}

\item{pairwise.deletion}{a logical passed to \code{\link[ape]{dist.dna}} indicating if pairwise deletions should be used; the alternative is to remove all sites for which at least one missing value is present.}

\item{method}{a function building a tree from a matrix of pairwise genetic distances.}

\item{ladderize}{a logical indicating if the tree should be ladderized; defaults to TRUE.}

\item{negative.branch.length}{a logical indicating if negative branch lengths should be allowed (e.g. in the case of Neighbor-Joining reconstruction), or not, in which case they are set to 0 (FALSE, default).}

\item{...}{further arguments passed to the tree reconstruction method defined by 'method'.}
}
\value{
a \code{multiPhylo} object
}
\description{
This function builds separate phylogenetic trees for each gene in a \linkS4class{multidna} object, specifying a method for computing pairwise distances between individuals, and a method to build the tree from the distance matrix. By default, procedures from ape are used.
}
\examples{
## simple conversion with nicely ordered output
data(woodmouse)
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[,501:965])
x <- new("multidna", genes)
x
plot(x)

## make trees, default parameters
trees <- getTree(x)
trees
plot(trees, type="unrooted")

## make one single tree based on concatenated genes
tree <- getTree(x, pool=TRUE)
tree
plot(tree, type="unrooted")
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\seealso{
\code{\link{dist.multidna}}
}

